/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameAnalyser;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.model.ALAParsedName;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.names.util.CleanedScientificName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gbif.api.exception.UnparsableException;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.service.checklistbank.NameParser;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.api.vocabulary.Rank;
import org.gbif.checklistbank.authorship.AuthorComparator;
import org.gbif.checklistbank.model.Equality;
import org.gbif.checklistbank.utils.SciNameNormalizer;
import org.gbif.common.parsers.NomStatusParser;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.nameparser.PhraseNameParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALANameAnalyser
extends NameAnalyser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ALANameAnalyser.class);
    private static final String DEFAULT_NOMENCLATURAL_CODE_MAP = "nomenclatural_codes.csv";
    private static final String DEFAULT_TAXONOMIC_TYPE_CODE_MAP = "taxonomic_type_codes.csv";
    private static final String DEFAULT_RANK_CODE_MAP = "rank_codes.csv";
    private static final String DEFAULT_NONEMCLATURAL_STATUS_CODE_MAP = "nomenclatural_status_codes.csv";
    private static final String DEFAULT_INFORMAL_PATTERN_LIST = "informal_names.csv";
    protected static final Pattern BRACKETED = Pattern.compile("\\s\\(\\s*\\p{Alpha}+\\s*\\)\\s");
    private static final String RANK_MARKERS = Arrays.stream(Rank.values()).filter(r -> r.getMarker() != null).map(r -> r.getMarker().replaceAll("\\.", "\\.")).collect(Collectors.joining("|"));
    private static final String RANK_PLACEHOLDER_MARKERS = "\\p{Alpha}\\.";
    protected static final Pattern MARKERS = Pattern.compile("\\s+(?:" + RANK_MARKERS + "|" + "\\p{Alpha}\\." + ")\\s+");
    protected static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9'\\- ]+");
    protected static final Pattern SPACES = Pattern.compile("\\s+");
    protected static final Pattern DOUBTFUL = Pattern.compile("((^| )(undet|indet|aff|cf)[#!?\\.]?)+(?![a-z])");
    protected static final Predicate<String> PLACEHOLDER_TEST = Pattern.compile("(?i:incertae sedis|unplaced)").asPredicate();
    protected static final Predicate<String> HYBRID_TEST = Pattern.compile(" x ").asPredicate();
    protected static final Predicate<String> CULTIVAR_TEST = Pattern.compile("\\p{Upper}\\p{Lower}+\\s+(?:\\p{Lower}+\\s+)?'[\\w\\s]+'").asPredicate();
    protected static final Predicate<String> INVALID_TEST = Pattern.compile("^[^\\p{Alpha}]*$").asPredicate();
    protected static final Predicate<String> DOUBTFUL_TEST = DOUBTFUL.asPredicate();
    protected static final Predicate<String> HIGHER_SCIENTIFIC_TEST = Pattern.compile("^\\p{Upper}[\\p{Alpha}\\-]+(\\s+\\p{Alpha}[\\p{Alpha}\\-]+)?$").asPredicate();
    protected static final Predicate<String> LOWER_SCIENTIFIC_TEST = Pattern.compile("^\\p{Upper}[\\p{Alpha}\\-]+\\s+\\p{Lower}[\\p{Lower}\\-]+(\\s+\\p{Lower}[\\p{Lower}\\-]+)?$").asPredicate();
    private Map<String, NomenclaturalCode> codeMap;
    private Map<String, TaxonomicType> taxonomicTypeMap;
    private Map<String, SynonymType> synonymMap;
    private Map<String, RankType> rankMap;
    private Map<String, NomenclaturalStatus> nomenclaturalStatusMap;
    private List<Pattern> informalPatterns;
    private NameParser nameParser = new PhraseNameParser();
    private NomStatusParser nomStatusParser = NomStatusParser.getInstance();
    private AuthorComparator authorComparator = AuthorComparator.createWithAuthormap();

    public ALANameAnalyser() {
        this.buildCodeMap();
        this.buildTaxonomicTypeMap();
        this.buildRankMap();
        this.buildNomenclaturalStatusMap();
        this.buildInformalPatternList();
    }

    @Override
    public NameKey analyse(NomenclaturalCode code, String scientificName, @Nullable String scientificNameAuthorship, @Nullable RankType rankType, boolean loose) {
        NameType nameType = NameType.INFORMAL;
        if (scientificNameAuthorship != null && scientificName.endsWith(scientificNameAuthorship)) {
            scientificName = scientificName.substring(0, scientificName.length() - scientificNameAuthorship.length()).trim();
        }
        if (loose && scientificNameAuthorship == null) {
            try {
                ParsedName name = this.nameParser.parse(scientificName, rankType == null ? null : rankType.getCbRank());
                String ac = name.authorshipComplete();
                if (ac != null && !ac.isEmpty() && !(name instanceof ALAParsedName)) {
                    scientificName = name.buildName(true, true, false, true, true, false, true, false, true, false, false, false, true, true);
                    scientificNameAuthorship = ac;
                    if (rankType == null && name.getRank() != null) {
                        rankType = RankType.getForCBRank(name.getRank());
                    }
                }
            }
            catch (UnparsableException name) {
                // empty catch block
            }
        }
        CleanedScientificName cleaned = new CleanedScientificName(scientificName);
        scientificName = cleaned.getBasic();
        scientificName = BRACKETED.matcher(scientificName).replaceAll(" ");
        if (PLACEHOLDER_TEST.test(scientificName = MARKERS.matcher(scientificName).replaceAll(" "))) {
            scientificName = UUID.randomUUID().toString();
            nameType = NameType.PLACEHOLDER;
        } else if (code == NomenclaturalCode.VIRUS) {
            nameType = NameType.VIRUS;
        } else if (code == NomenclaturalCode.BACTERIAL) {
            nameType = NameType.SCIENTIFIC;
        } else if (HYBRID_TEST.test(scientificName)) {
            nameType = NameType.HYBRID;
        } else if (code == NomenclaturalCode.CULTIVARS || CULTIVAR_TEST.test(scientificName)) {
            nameType = NameType.CULTIVAR;
        } else if (INVALID_TEST.test(scientificName)) {
            scientificName = UUID.randomUUID().toString();
            nameType = NameType.NO_NAME;
        } else if (DOUBTFUL_TEST.test(scientificName)) {
            nameType = NameType.DOUBTFUL;
        } else if (rankType == null && (HIGHER_SCIENTIFIC_TEST.test(scientificName) || LOWER_SCIENTIFIC_TEST.test(scientificName))) {
            nameType = NameType.SCIENTIFIC;
        } else if (rankType != null && rankType.isHigherThan(RankType.SPECIES) && HIGHER_SCIENTIFIC_TEST.test(scientificName)) {
            nameType = NameType.SCIENTIFIC;
        } else if (LOWER_SCIENTIFIC_TEST.test(scientificName)) {
            nameType = NameType.SCIENTIFIC;
            scientificName = SciNameNormalizer.normalize((String)scientificName);
        } else {
            nameType = NameType.INFORMAL;
        }
        if (rankType == null) {
            rankType = RankType.UNRANKED;
        }
        if (loose) {
            scientificName = DOUBTFUL.matcher(scientificName).replaceAll(" ");
        }
        scientificName = NON_NAME.matcher(scientificName).replaceAll(" ");
        scientificName = SPACES.matcher(scientificName).replaceAll(" ");
        scientificName = scientificName.trim().toUpperCase();
        if (scientificNameAuthorship != null) {
            CleanedScientificName cleanedAuthor = new CleanedScientificName(scientificNameAuthorship);
            scientificNameAuthorship = cleanedAuthor.getBasic();
        }
        scientificNameAuthorship = scientificNameAuthorship == null || scientificNameAuthorship.isEmpty() ? null : scientificNameAuthorship;
        return new NameKey(this, code, scientificName.toUpperCase(), scientificNameAuthorship, rankType, nameType);
    }

    protected <T extends Enum<T>> void loadCsv(String resource, Map<String, T> map, Class<T> clazz) {
        try {
            String[] next;
            CSVReader reader = new CSVReader((Reader)new InputStreamReader(this.getClass().getResourceAsStream(resource), "UTF-8"), ',', '\"', 1);
            while ((next = reader.readNext()) != null) {
                String label = next[0];
                String val = next[1];
                Object value = null;
                if (val != null) {
                    value = (val = val.trim()).isEmpty() ? null : Enum.valueOf(clazz, val);
                }
                map.put(label.toUpperCase().trim(), value);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to build map for " + clazz, (Throwable)ex);
        }
    }

    protected void loadPatternCsv(String resource, List<Pattern> list) {
        try {
            String[] next;
            CSVReader reader = new CSVReader((Reader)new InputStreamReader(this.getClass().getResourceAsStream(resource), "UTF-8"), ',', '\"', 1);
            while ((next = reader.readNext()) != null) {
                String label = next[0];
                String val = next[1];
                if (val != null) {
                    val = (val = val.trim()).isEmpty() ? null : val;
                }
                Pattern value = Pattern.compile(val);
                list.add(value);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to build pattern list", (Throwable)ex);
        }
    }

    protected void buildCodeMap() {
        this.codeMap = new HashMap<String, NomenclaturalCode>(64);
        for (NomenclaturalCode c : NomenclaturalCode.values()) {
            this.codeMap.put(c.getAcronym().toUpperCase().trim(), c);
        }
        this.loadCsv(DEFAULT_NOMENCLATURAL_CODE_MAP, this.codeMap, NomenclaturalCode.class);
    }

    protected void buildTaxonomicTypeMap() {
        this.taxonomicTypeMap = new HashMap<String, TaxonomicType>(64);
        for (TaxonomicType s : TaxonomicType.values()) {
            this.taxonomicTypeMap.put(s.getTerm().toUpperCase().trim(), s);
            if (s.getLabels() == null) continue;
            for (String l : s.getLabels()) {
                this.taxonomicTypeMap.put(l.toUpperCase().trim(), s);
            }
        }
        this.loadCsv(DEFAULT_TAXONOMIC_TYPE_CODE_MAP, this.taxonomicTypeMap, TaxonomicType.class);
    }

    protected void buildRankMap() {
        this.rankMap = new HashMap<String, RankType>(64);
        for (RankType r : RankType.values()) {
            this.rankMap.put(r.getRank().toUpperCase().trim(), r);
            if (r.getStrRanks() == null) continue;
            for (String label : r.getStrRanks()) {
                this.rankMap.put(label.toUpperCase().trim(), r);
            }
        }
        this.loadCsv(DEFAULT_RANK_CODE_MAP, this.rankMap, RankType.class);
    }

    protected void buildNomenclaturalStatusMap() {
        this.nomenclaturalStatusMap = new HashMap<String, NomenclaturalStatus>(64);
        this.loadCsv(DEFAULT_NONEMCLATURAL_STATUS_CODE_MAP, this.nomenclaturalStatusMap, NomenclaturalStatus.class);
    }

    protected void buildInformalPatternList() {
        this.informalPatterns = new ArrayList<Pattern>(32);
        this.loadPatternCsv(DEFAULT_INFORMAL_PATTERN_LIST, this.informalPatterns);
    }

    @Override
    public NomenclaturalCode canonicaliseCode(String code) {
        if (code == null) {
            return null;
        }
        NomenclaturalCode nc = this.codeMap.get(code = code.toUpperCase().trim());
        if (nc == null) {
            this.report(IssueType.PROBLEM, "nomenclaturalCode.notFound", code);
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaxonomicType canonicaliseTaxonomicType(String taxonomicStatus) {
        if (taxonomicStatus == null) {
            return TaxonomicType.INFERRED_UNPLACED;
        }
        if ((taxonomicStatus = taxonomicStatus.toUpperCase().trim()).isEmpty()) {
            return TaxonomicType.INFERRED_UNPLACED;
        }
        TaxonomicType type = this.taxonomicTypeMap.get(taxonomicStatus);
        if (type == null) {
            this.report(IssueType.PROBLEM, "taxonomicStatus.notFound", taxonomicStatus);
            type = TaxonomicType.INFERRED_UNPLACED;
            ALANameAnalyser aLANameAnalyser = this;
            synchronized (aLANameAnalyser) {
                this.taxonomicTypeMap.put(taxonomicStatus, type);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RankType canonicaliseRank(String rank) {
        if (rank == null) {
            return RankType.UNRANKED;
        }
        if ((rank = rank.toUpperCase().trim()).isEmpty()) {
            return RankType.UNRANKED;
        }
        RankType rankType = this.rankMap.get(rank);
        if (rankType == null) {
            this.report(IssueType.PROBLEM, "rank.notFound", rank);
            rankType = RankType.UNRANKED;
            ALANameAnalyser aLANameAnalyser = this;
            synchronized (aLANameAnalyser) {
                this.rankMap.put(rank, rankType);
            }
        }
        return rankType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NomenclaturalStatus canonicaliseNomenclaturalStatus(String nomenclaturalStatus) {
        if (nomenclaturalStatus == null) {
            return null;
        }
        ParseResult parsed = this.nomStatusParser.parse(nomenclaturalStatus);
        if (parsed.isSuccessful()) {
            return (NomenclaturalStatus)parsed.getPayload();
        }
        if ((nomenclaturalStatus = nomenclaturalStatus.toUpperCase().trim()).isEmpty()) {
            return null;
        }
        NomenclaturalStatus status = this.nomenclaturalStatusMap.get(nomenclaturalStatus);
        if (status == null && !this.nomenclaturalStatusMap.containsKey(nomenclaturalStatus)) {
            this.report(IssueType.PROBLEM, "nomenclaturalStatus.notFound", nomenclaturalStatus);
            ALANameAnalyser aLANameAnalyser = this;
            synchronized (aLANameAnalyser) {
                this.nomenclaturalStatusMap.put(nomenclaturalStatus, null);
            }
        }
        return status;
    }

    @Override
    public boolean isInformal(String name) {
        for (Pattern p : this.informalPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(NameKey key1, NameKey key2) {
        int cmp;
        if (key1.getCode() == null && key2.getCode() != null) {
            return -1;
        }
        if (key1.getCode() != null && key2.getCode() == null) {
            return 1;
        }
        if (key1.getCode() != null && key2.getCode() != null && (cmp = key1.getCode().compareTo((Enum)key2.getCode())) != 0) {
            return cmp;
        }
        cmp = key1.getScientificName().compareTo(key2.getScientificName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = key1.getRank().compareTo(key2.getRank());
        if (cmp != 0) {
            return cmp;
        }
        if (key1.getScientificNameAuthorship() == null && key2.getScientificNameAuthorship() == null) {
            return 0;
        }
        if (key1.getScientificNameAuthorship() == null && key2.getScientificNameAuthorship() != null) {
            return -1;
        }
        if (key1.getScientificNameAuthorship() != null && key2.getScientificNameAuthorship() == null) {
            return 1;
        }
        if (this.authorComparator.compare(key1.getScientificNameAuthorship(), null, key2.getScientificNameAuthorship(), null) == Equality.EQUAL) {
            return 0;
        }
        return key1.getScientificNameAuthorship().compareTo(key2.getScientificNameAuthorship());
    }

    @Override
    public int hashCode(NameKey key1) {
        int hash = key1.getCode() != null ? key1.getCode().hashCode() : 1181;
        hash = hash * 31 + key1.getScientificName().hashCode();
        hash = hash * 31 + (key1.getScientificNameAuthorship() == null ? 0 : 5659);
        return hash;
    }
}

