/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.util.spring;

import com.google.common.base.Strings;

public abstract class Assert {
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void hasText(String text, String message) {
        if (Strings.isNullOrEmpty((String)text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text) {
        Assert.hasText(text, "[Assertion failed] - this String argument must have text; it must not be <code>null</code>, empty, or blank");
    }
}

