/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XSSUtil.class);
    private static final Pattern NULL_CHAR = Pattern.compile("\u0000");
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("<script>(.*?)</script>", 2), Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42), Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42), Pattern.compile("</script>", 2), Pattern.compile("<iframe>(.*?)</iframe>", 2), Pattern.compile("<script(.*?)>", 42), Pattern.compile("<img(.*?)>", 42), Pattern.compile("eval\\((.*?)\\)", 42), Pattern.compile("expression\\((.*?)\\)", 42), Pattern.compile("javascript:", 2), Pattern.compile("vbscript:", 2), Pattern.compile("onload(.*?)=", 42)};

    private XSSUtil() {
    }

    public static boolean containsXSS(String value) {
        if (value != null) {
            String cleanValue = NULL_CHAR.matcher(value).replaceAll("");
            for (Pattern scriptPattern : PATTERNS) {
                Matcher matcher = scriptPattern.matcher(cleanValue);
                if (!matcher.find()) continue;
                LOG.warn("Malicious XSS script found: {}", (Object)cleanValue);
                return true;
            }
        }
        return false;
    }

    public static String stripXSS(String value) {
        if (value == null) {
            return null;
        }
        String cleanValue = NULL_CHAR.matcher(value).replaceAll("");
        if (StringUtils.isBlank((CharSequence)cleanValue)) {
            return cleanValue;
        }
        for (Pattern scriptPattern : PATTERNS) {
            Matcher matcher = scriptPattern.matcher(cleanValue);
            cleanValue = matcher.replaceAll("");
        }
        return cleanValue;
    }
}

