/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.provider;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class ValidationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private static final int HTTP_CODE = 422;
    private static final Logger LOG = LoggerFactory.getLogger(ValidationExceptionMapper.class);

    public Response toResponse(ConstraintViolationException exception) {
        LOG.error(exception.getMessage(), (Throwable)exception);
        ImmutableList.Builder b = ImmutableList.builder();
        for (ConstraintViolation cv : exception.getConstraintViolations()) {
            LOG.debug("Validation of [{}] failed: {}", (Object)cv.getPropertyPath(), (Object)cv.getMessage());
            b.add((Object)String.format("Validation of [%s] failed: %s", cv.getPropertyPath(), cv.getMessage()));
        }
        return Response.status((int)422).type("text/plain").entity((Object)("<ul><li>" + Joiner.on((String)"</li><li>").join((Iterable)b.build()) + "</li></ul>")).build();
    }
}

