/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.provider;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.search.SearchParameter;
import org.gbif.api.model.common.search.SearchRequest;
import org.gbif.api.util.SearchTypeValidator;
import org.gbif.api.util.VocabularyUtils;
import org.gbif.ws.server.provider.PageableProvider;

public class SearchRequestProvider<RT extends SearchRequest<P>, P extends Enum<?>>
extends AbstractHttpContextInjectable<RT>
implements InjectableProvider<Context, Type> {
    private final Class<P> searchParameterClass;
    private final Class<RT> requestType;
    private static final int NON_SPELL_CHECK_COUNT = -1;

    public SearchRequestProvider(Class<RT> requestType, Class<P> searchParameterClass) {
        this.requestType = requestType;
        this.searchParameterClass = searchParameterClass;
    }

    public Injectable<RT> getInjectable(ComponentContext ic, Context context, Type type) {
        if (type.equals(this.requestType)) {
            return this;
        }
        return null;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public RT getValue(HttpContext context) {
        try {
            SearchRequest req = (SearchRequest)this.requestType.newInstance();
            return (RT)this.getSearchRequest(context, req);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    protected P findSearchParam(String name) {
        try {
            return (P)VocabularyUtils.lookupEnum((String)name, this.searchParameterClass);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected RT getSearchRequest(HttpContext context, RT searchRequest) {
        searchRequest.copyPagingValues((Pageable)PageableProvider.getPagingRequest(context));
        MultivaluedMap params = context.getRequest().getQueryParameters();
        this.getSearchRequestFromQueryParams(searchRequest, (MultivaluedMap<String, String>)params);
        return searchRequest;
    }

    protected void getSearchRequestFromQueryParams(RT searchRequest, MultivaluedMap<String, String> params) {
        String q = (String)params.getFirst((Object)"q");
        String highlightValue = (String)params.getFirst((Object)"hl");
        String spellCheck = (String)params.getFirst((Object)"spellCheck");
        String spellCheckCount = (String)params.getFirst((Object)"spellCheckCount");
        if (!Strings.isNullOrEmpty((String)q)) {
            searchRequest.setQ(q);
        }
        if (!Strings.isNullOrEmpty((String)highlightValue)) {
            searchRequest.setHighlight(Boolean.parseBoolean(highlightValue));
        }
        if (!Strings.isNullOrEmpty((String)spellCheck)) {
            searchRequest.setSpellCheck(Boolean.parseBoolean(spellCheck));
        }
        if (!Strings.isNullOrEmpty((String)spellCheckCount)) {
            searchRequest.setSpellCheckCount(Integer.parseInt(spellCheckCount));
        } else {
            searchRequest.setSpellCheckCount(-1);
        }
        this.setSearchParams(searchRequest, params);
    }

    private static List<String> removeEmptyParameters(List<String> parameters) {
        ArrayList cleanParameters = Lists.newArrayListWithCapacity((int)parameters.size());
        for (String param : parameters) {
            String cleanParam = Strings.nullToEmpty((String)param).trim();
            if (cleanParam.isEmpty()) continue;
            cleanParameters.add(cleanParam);
        }
        return cleanParameters;
    }

    private void setSearchParams(RT searchRequest, MultivaluedMap<String, String> params) {
        for (Map.Entry entry : params.entrySet()) {
            P p = this.findSearchParam((String)entry.getKey());
            if (p == null) continue;
            for (String val : SearchRequestProvider.removeEmptyParameters((List)entry.getValue())) {
                SearchTypeValidator.validate((SearchParameter)((SearchParameter)p), (String)val);
                searchRequest.addParameter((SearchParameter)p, val);
            }
        }
    }
}

