/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.provider;

import com.google.inject.Singleton;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class PageableProvider
extends AbstractHttpContextInjectable<Pageable>
implements InjectableProvider<Context, Type> {
    private static final Logger LOG = LoggerFactory.getLogger(PageableProvider.class);

    public Injectable<Pageable> getInjectable(ComponentContext ic, Context a, Type c) {
        if (c.equals(Pageable.class)) {
            return this;
        }
        return null;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Pageable getValue(HttpContext c) {
        return PageableProvider.getPagingRequest(c);
    }

    public static PagingRequest getPagingRequest(HttpContext c) {
        MultivaluedMap params = c.getRequest().getQueryParameters();
        int limit = 20;
        if (params.getFirst((Object)"limit") != null) {
            try {
                limit = Integer.parseInt((String)params.getFirst((Object)"limit"));
                if (limit < 0) {
                    LOG.info("Limit parameter was no positive integer [{}]. Using default {}", params.getFirst((Object)"limit"), (Object)20);
                    limit = 20;
                }
            }
            catch (NumberFormatException e) {
                LOG.warn("Unparsable value supplied for limit [{}]. Using default {}", params.getFirst((Object)"limit"), (Object)20);
            }
        }
        long offset = 0L;
        if (params.getFirst((Object)"offset") != null) {
            try {
                offset = Long.parseLong((String)params.getFirst((Object)"offset"));
                if (offset < 0L) {
                    LOG.warn("Offset parameter is a negative integer [{}]. Using default {}", params.getFirst((Object)"offset"), (Object)0L);
                    offset = 0L;
                }
            }
            catch (NumberFormatException e) {
                LOG.warn("Unparsable value supplied for offset [{}]. Using default {}", params.getFirst((Object)"offset"), (Object)0L);
            }
        }
        return new PagingRequest(offset, limit);
    }
}

