/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.provider;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
@Singleton
public class LocaleProvider
extends AbstractHttpContextInjectable<Locale>
implements InjectableProvider<Context, Type> {
    private static final String LANGUAGE_PARAM = "language";
    private static final String ANY_LANGUAGE = "*";

    public Injectable<Locale> getInjectable(ComponentContext ic, Context a, Type c) {
        if (c.equals(Locale.class)) {
            return this;
        }
        return null;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Locale getValue(HttpContext c) {
        return LocaleProvider.getLocale(c);
    }

    public static Locale getLocale(HttpContext c) {
        String lang;
        if (c.getRequest().getQueryParameters() != null && c.getRequest().getQueryParameters().containsKey((Object)LANGUAGE_PARAM) && !Strings.isNullOrEmpty((String)(lang = ((String)c.getRequest().getQueryParameters().getFirst((Object)LANGUAGE_PARAM)).trim().toLowerCase())) && lang.length() == 2) {
            return new Locale(lang);
        }
        List locales = c.getRequest().getAcceptableLanguages();
        for (Locale loc : locales) {
            if (Strings.isNullOrEmpty((String)loc.getLanguage()) || ANY_LANGUAGE.equalsIgnoreCase(loc.getLanguage()) || loc.getLanguage().length() != 2) continue;
            return loc;
        }
        return null;
    }
}

