/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.provider;

import com.google.common.base.Strings;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.gbif.api.model.common.search.FacetedSearchRequest;
import org.gbif.api.model.common.search.SearchParameter;
import org.gbif.ws.server.provider.SearchRequestProvider;

public class FacetedSearchRequestProvider<RT extends FacetedSearchRequest<P>, P extends Enum<?>>
extends SearchRequestProvider<RT, P>
implements InjectableProvider<Context, Type> {
    private static final int DEFAULT_FACET_LIMIT = 10;

    public FacetedSearchRequestProvider(Class<RT> requestType, Class<P> searchParameterClass) {
        super(requestType, searchParameterClass);
    }

    @Override
    protected RT getSearchRequest(HttpContext context, RT searchRequest) {
        List facets;
        String facetOffset;
        String facetLimit;
        String facetMinCountValue;
        FacetedSearchRequest request = (FacetedSearchRequest)super.getSearchRequest(context, searchRequest);
        MultivaluedMap params = context.getRequest().getQueryParameters();
        String facetMultiSelectValue = FacetedSearchRequestProvider.getFirstIgnoringCase("facetMultiselect", (MultivaluedMap<String, String>)params);
        if (facetMultiSelectValue != null) {
            searchRequest.setMultiSelectFacets(Boolean.parseBoolean(facetMultiSelectValue));
        }
        if ((facetMinCountValue = FacetedSearchRequestProvider.getFirstIgnoringCase("facetMincount", (MultivaluedMap<String, String>)params)) != null) {
            searchRequest.setFacetMinCount(Integer.valueOf(Integer.parseInt(facetMinCountValue)));
        }
        if ((facetLimit = FacetedSearchRequestProvider.getFirstIgnoringCase("facetLimit", (MultivaluedMap<String, String>)params)) != null) {
            searchRequest.setFacetLimit(Integer.valueOf(Integer.parseInt(facetLimit)));
        }
        if ((facetOffset = FacetedSearchRequestProvider.getFirstIgnoringCase("facetOffset", (MultivaluedMap<String, String>)params)) != null) {
            searchRequest.setFacetOffset(Integer.valueOf(Integer.parseInt(facetOffset)));
        }
        if ((facets = (List)params.get((Object)"facet")) != null && !facets.isEmpty()) {
            for (String f : facets) {
                Object p = this.findSearchParam(f);
                if (p == null) continue;
                searchRequest.addFacets((SearchParameter[])new Enum[]{p});
                String pFacetOffset = FacetedSearchRequestProvider.getFirstIgnoringCase(f + '.' + "facetOffset", (MultivaluedMap<String, String>)params);
                String pFacetLimit = FacetedSearchRequestProvider.getFirstIgnoringCase(f + '.' + "facetLimit", (MultivaluedMap<String, String>)params);
                if (pFacetLimit != null) {
                    if (pFacetOffset != null) {
                        searchRequest.addFacetPage((SearchParameter)p, Integer.parseInt(pFacetOffset), Integer.parseInt(pFacetLimit));
                        continue;
                    }
                    searchRequest.addFacetPage((SearchParameter)p, 0, Integer.parseInt(pFacetLimit));
                    continue;
                }
                if (pFacetOffset == null) continue;
                searchRequest.addFacetPage((SearchParameter)p, Integer.parseInt(pFacetOffset), 10);
            }
        }
        return (RT)request;
    }

    private static String getFirstIgnoringCase(String parameter, MultivaluedMap<String, String> params) {
        String value = (String)params.getFirst((Object)parameter);
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = (String)params.getFirst((Object)parameter.toLowerCase());
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = (String)params.getFirst((Object)parameter.toUpperCase());
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return null;
    }
}

