/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.guice;

import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.util.List;
import javax.annotation.Nullable;
import org.gbif.ws.server.filter.CreatedResponseFilter;
import org.gbif.ws.server.filter.CrossDomainResponseFilter;
import org.gbif.ws.server.filter.JsonpResponseFilter;

public class WsJerseyModuleConfiguration {
    private String resourcePackages;
    private Boolean installAuthenticationFilter;
    private Class<? extends ContainerRequestFilter> authenticationFilterClass;
    private List<Class<? extends ContainerResponseFilter>> defaultResponseFilters = Lists.newArrayList();
    private List<Class<? extends ContainerResponseFilter>> responseFilters = Lists.newArrayList();
    private List<Class<? extends ContainerRequestFilter>> requestFilters = Lists.newLinkedList();

    public WsJerseyModuleConfiguration() {
        this.defaultResponseFilters.add(JsonpResponseFilter.class);
        this.defaultResponseFilters.add(CreatedResponseFilter.class);
        this.defaultResponseFilters.add(CrossDomainResponseFilter.class);
    }

    public WsJerseyModuleConfiguration resourcePackages(String resourcePackages) {
        this.resourcePackages = resourcePackages;
        return this;
    }

    public WsJerseyModuleConfiguration installAuthenticationFilter(boolean installAuthenticationFilter) {
        this.installAuthenticationFilter = installAuthenticationFilter;
        return this;
    }

    public WsJerseyModuleConfiguration useAuthenticationFilter(Class<? extends ContainerRequestFilter> authenticationFilterClass) {
        this.installAuthenticationFilter = true;
        this.authenticationFilterClass = authenticationFilterClass;
        return this;
    }

    public WsJerseyModuleConfiguration responseFilters(@Nullable List<Class<? extends ContainerResponseFilter>> responseFilters) {
        if (responseFilters != null) {
            this.responseFilters.addAll(responseFilters);
        }
        return this;
    }

    public WsJerseyModuleConfiguration requestFilters(@Nullable List<Class<? extends ContainerRequestFilter>> requestFilters) {
        if (requestFilters != null) {
            this.requestFilters.addAll(requestFilters);
        }
        return this;
    }

    public WsJerseyModuleConfiguration replaceDefaultResponseFilters(List<Class<? extends ContainerResponseFilter>> defaultResponseFilters) {
        this.defaultResponseFilters.clear();
        if (defaultResponseFilters != null) {
            this.defaultResponseFilters.addAll(defaultResponseFilters);
        }
        return this;
    }

    public String getResourcePackages() {
        return this.resourcePackages;
    }

    public Boolean isInstallAuthenticationFilter() {
        return this.installAuthenticationFilter;
    }

    public Class<? extends ContainerRequestFilter> getAuthenticationFilterClass() {
        return this.authenticationFilterClass;
    }

    public List<Class<? extends ContainerResponseFilter>> getDefaultResponseFilters() {
        return this.defaultResponseFilters;
    }

    public List<Class<? extends ContainerResponseFilter>> getResponseFilters() {
        return this.responseFilters;
    }

    public List<Class<? extends ContainerRequestFilter>> getRequestFilters() {
        return this.requestFilters;
    }
}

