/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.guice;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.matcher.Matchers;
import com.sun.jersey.api.container.filter.RolesAllowedResourceFilterFactory;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.gbif.ws.json.JacksonJsonContextResolver;
import org.gbif.ws.server.filter.AuthFilter;
import org.gbif.ws.server.filter.AuthResponseFilter;
import org.gbif.ws.server.filter.RequestHeaderParamUpdateFilter;
import org.gbif.ws.server.guice.WsJerseyModuleConfiguration;
import org.gbif.ws.server.interceptor.NullToNotFound;
import org.gbif.ws.server.interceptor.NullToNotFoundInterceptor;

public class WsJerseyModule
extends JerseyServletModule {
    private final WsJerseyModuleConfiguration config;
    private static final String ROOT_RESOURCES = "org.gbif.ws.server.provider,";
    private final Function<Class<?>, String> fnClassName = new Function<Class<?>, String>(){

        public String apply(Class<?> input) {
            return input.getName();
        }
    };

    public WsJerseyModule(String resourcePackages, boolean installAuth, @Nullable List<Class<? extends ContainerResponseFilter>> responseFilters) {
        this(resourcePackages, installAuth, responseFilters, null);
    }

    public WsJerseyModule(String resourcePackages, boolean installAuth, @Nullable List<Class<? extends ContainerResponseFilter>> responseFilters, List<Class<? extends ContainerRequestFilter>> requestFilters) {
        this.config = new WsJerseyModuleConfiguration().resourcePackages(resourcePackages).installAuthenticationFilter(installAuth).responseFilters(responseFilters).requestFilters(requestFilters);
    }

    public WsJerseyModule(WsJerseyModuleConfiguration config) {
        Preconditions.checkNotNull((Object)config.isInstallAuthenticationFilter(), (Object)"installAuthenticationFilter must be set");
        this.config = config;
    }

    protected void configureServlets() {
        HashMap<String, String> params = new HashMap<String, String>(6);
        this.bind(JacksonJsonContextResolver.class);
        params.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
        HashMap mediaTypes = Maps.newHashMap();
        mediaTypes.put("json", "application/json");
        mediaTypes.put("xml", "application/xml");
        mediaTypes.put("txt", "text/plain");
        mediaTypes.put("zip", "application/octet-stream");
        params.put("com.sun.jersey.config.property.MediaTypeMappings", Joiner.on((String)", ").withKeyValueSeparator(" : ").join((Map)mediaTypes));
        params.put("com.sun.jersey.config.property.packages", ROOT_RESOURCES + this.config.getResourcePackages());
        params.put(ResourceFilters.class.getName(), RolesAllowedResourceFilterFactory.class.getName());
        LinkedList reqFilters = Lists.newLinkedList();
        if (this.config.isInstallAuthenticationFilter().booleanValue()) {
            if (this.config.getAuthenticationFilterClass() != null) {
                reqFilters.addFirst(this.config.getAuthenticationFilterClass());
            } else {
                reqFilters.addFirst(AuthFilter.class);
            }
        }
        reqFilters.addFirst(RequestHeaderParamUpdateFilter.class);
        reqFilters.addAll(this.config.getRequestFilters());
        params.put("com.sun.jersey.spi.container.ContainerRequestFilters", Joiner.on((String)";").join((Iterable)Lists.transform((List)reqFilters, this.fnClassName)));
        ArrayList respFilters = Lists.newArrayList();
        respFilters.addAll(this.config.getDefaultResponseFilters());
        if (this.config.isInstallAuthenticationFilter().booleanValue()) {
            respFilters.add(AuthResponseFilter.class);
        }
        respFilters.addAll(this.config.getResponseFilters());
        params.put("com.sun.jersey.spi.container.ContainerResponseFilters", Joiner.on((String)";").join((Iterable)Lists.transform((List)respFilters, this.fnClassName)));
        this.serve("/*", new String[0]).with(GuiceContainer.class, params);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(NullToNotFound.class), new MethodInterceptor[]{new NullToNotFoundInterceptor()});
    }
}

