/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.guice;

import com.google.common.collect.Maps;
import com.google.inject.PrivateModule;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.gbif.utils.file.properties.PropertiesUtil;
import org.gbif.ws.security.GbifAuthService;

public class WsAuthModule
extends PrivateModule {
    public static final String PROPERTY_APPKEY_FILEPATH = "appkeys.file";
    private final GbifAuthService authService;

    public WsAuthModule(Map<String, String> keys) {
        this.authService = GbifAuthService.multiKeyAuthService(keys);
    }

    public WsAuthModule(String appKeyStoreFilePath) {
        try {
            Properties props = PropertiesUtil.loadProperties((String)appKeyStoreFilePath);
            this.authService = GbifAuthService.multiKeyAuthService((Map<String, String>)Maps.fromProperties((Properties)props));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Property file path to application keys does not exist: " + appKeyStoreFilePath, e);
        }
    }

    public WsAuthModule(Properties properties) {
        this(properties.getProperty(PROPERTY_APPKEY_FILEPATH));
    }

    protected void configure() {
        this.bind(GbifAuthService.class).toInstance((Object)this.authService);
        this.expose(GbifAuthService.class);
    }
}

