/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.guice;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.SerializationConfig;
import org.gbif.utils.file.properties.PropertiesUtil;
import org.gbif.ws.json.JacksonJsonContextResolver;
import org.gbif.ws.server.guice.WsJerseyModule;
import org.gbif.ws.server.guice.WsJerseyModuleConfiguration;

public abstract class GbifServletListener
extends GuiceServletContextListener {
    private final Properties properties;
    private final WsJerseyModuleConfiguration moduleConfig;
    private Injector injector;

    protected GbifServletListener(Properties properties, String resourcePackages, boolean installAuthenticationFilters) {
        this(properties, resourcePackages, installAuthenticationFilters, null);
    }

    protected GbifServletListener(Properties properties, String resourcePackages, boolean installAuthenticationFilters, @Nullable List<Class<? extends ContainerResponseFilter>> responseFilters) {
        this(properties, resourcePackages, installAuthenticationFilters, responseFilters, null);
    }

    protected GbifServletListener(String propertyFileName, String resourcePackages, boolean installAuthenticationFilters, @Nullable List<Class<? extends ContainerResponseFilter>> responseFilters) {
        this(GbifServletListener.readProperties(propertyFileName), resourcePackages, installAuthenticationFilters, responseFilters);
    }

    protected GbifServletListener(Properties properties, String resourcePackages, boolean installAuthenticationFilters, @Nullable List<Class<? extends ContainerResponseFilter>> responseFilters, @Nullable List<Class<? extends ContainerRequestFilter>> requestFilters) {
        this(properties, new WsJerseyModuleConfiguration().resourcePackages(resourcePackages).installAuthenticationFilter(installAuthenticationFilters).responseFilters(responseFilters).requestFilters(requestFilters));
    }

    protected GbifServletListener(Properties properties, WsJerseyModuleConfiguration moduleConfig) {
        this.properties = properties;
        this.moduleConfig = moduleConfig;
    }

    private static Properties readProperties(String propertyFileName) {
        Properties properties = null;
        try {
            properties = PropertiesUtil.loadProperties((String)propertyFileName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading properties file", e);
        }
        return properties;
    }

    protected GbifServletListener(String propertyFileName, String resourcePackages, boolean installAuthenticationFilters) {
        this(propertyFileName, resourcePackages, installAuthenticationFilters, null);
    }

    protected abstract List<Module> getModules(Properties var1);

    protected Map<Class<?>, Class<?>> getMixIns() {
        return Maps.newHashMap();
    }

    protected List<SerializationConfig.Feature> getAdditionalDisabledFeature() {
        return Collections.emptyList();
    }

    protected synchronized Injector getInjector() {
        if (this.injector == null) {
            JacksonJsonContextResolver.addMixIns(this.getMixIns());
            JacksonJsonContextResolver.disableFeature(this.getAdditionalDisabledFeature());
            List<Module> modules = this.getModules(this.properties);
            modules.add((Module)new WsJerseyModule(this.moduleConfig));
            this.injector = Guice.createInjector(modules);
        }
        return this.injector;
    }
}

