/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.filter;

import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gbif.api.model.common.messaging.Response;
import org.gbif.ws.util.XSSUtil;

@Singleton
public class XSSFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            XSSFilter.checkParams(httpRequest.getHeaderNames(), httpRequest, response);
            if (XSSUtil.containsXSS(httpRequest.getQueryString())) {
                XSSFilter.respondBadRequest(response);
            }
            XSSFilter.checkParams(httpRequest.getParameterNames(), httpRequest, response);
        }
        chain.doFilter(request, response);
    }

    private static void checkParams(Enumeration<String> params, HttpServletRequest request, ServletResponse response) throws IOException {
        while (params.hasMoreElements()) {
            if (!XSSUtil.containsXSS(request.getParameter(params.nextElement()))) continue;
            XSSFilter.respondBadRequest(response);
        }
    }

    private static void respondBadRequest(ServletResponse response) throws IOException {
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!resp.isCommitted()) {
            resp.sendError(Response.StatusCode.BAD_REQUEST.getCode().intValue());
        }
    }
}

