/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.filter;

import com.google.common.base.Strings;
import com.sun.jersey.api.json.JSONWithPadding;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import org.gbif.ws.util.ExtraMediaTypes;

public class JsonpResponseFilter
implements ContainerResponseFilter {
    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        if (response.getMediaType() == null || !response.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) && !response.getMediaType().equals((Object)ExtraMediaTypes.APPLICATION_JAVASCRIPT_TYPE)) {
            return response;
        }
        String callback = Strings.nullToEmpty((String)((String)request.getQueryParameters().getFirst((Object)"callback")));
        if (callback.isEmpty()) {
            return response;
        }
        if (response.getEntity() != null) {
            JSONWithPadding jsonp = new JSONWithPadding(response.getEntity(), callback);
            response.setEntity((Object)jsonp);
            return response;
        }
        return response;
    }
}

