/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.filter;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.sun.jersey.core.util.Base64;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.security.Principal;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.gbif.api.model.common.User;
import org.gbif.api.model.common.UserPrincipal;
import org.gbif.api.service.common.UserService;
import org.gbif.ws.security.GbifAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AuthFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
    private static final Pattern COLON_PATTERN = Pattern.compile(":");
    private final UserService userService;
    private final GbifAuthService authService;
    @Context
    private UriInfo uriInfo;
    private static final String GBIF_SCHEME_PREFIX = "GBIF ";
    private static final String BASIC_SCHEME_PREFIX = "Basic ";

    @Inject
    public AuthFilter(@NotNull UserService userService, @Nullable GbifAuthService authService) {
        this.userService = userService;
        this.authService = authService;
    }

    public ContainerRequest filter(ContainerRequest request) {
        Authorizer authorizer = null;
        if (this.userService != null) {
            authorizer = this.authenticate(request);
        }
        if (authorizer == null) {
            authorizer = new Authorizer();
        }
        request.setSecurityContext((SecurityContext)authorizer);
        return request;
    }

    private Authorizer authenticate(ContainerRequest request) {
        String authentication = request.getHeaderValue("Authorization");
        if (authentication != null) {
            if (authentication.startsWith(BASIC_SCHEME_PREFIX)) {
                return this.basicAuthentication(authentication.substring(BASIC_SCHEME_PREFIX.length()));
            }
            if (authentication.startsWith(GBIF_SCHEME_PREFIX)) {
                return this.gbifAuthentication(request);
            }
        }
        return new Authorizer();
    }

    private Authorizer basicAuthentication(String authentication) {
        String[] values = COLON_PATTERN.split(Base64.base64Decode((String)authentication));
        if (values.length < 2) {
            LOG.warn("Invalid syntax for username and password: {}", (Object)authentication);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String username = values[0];
        String password = values[1];
        if (username == null || password == null) {
            LOG.warn("Missing basic authentication username or password: {}", (Object)authentication);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            UUID.fromString(username);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            User user = this.userService.authenticate(username, password);
            if (user == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            LOG.debug("Authenticating user {} via scheme {}", (Object)username, (Object)"BASIC");
            return new Authorizer(user, "BASIC");
        }
    }

    private Authorizer gbifAuthentication(ContainerRequest request) {
        String username = request.getHeaderValue("x-gbif-user");
        if (Strings.isNullOrEmpty((String)username)) {
            LOG.warn("Missing gbif username header {}", (Object)"x-gbif-user");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.authService == null) {
            LOG.warn("No GbifAuthService defined.");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!this.authService.isValidRequest(request)) {
            LOG.warn("Invalid GBIF authenticated request");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        LOG.debug("Authenticating user {} via scheme {}", (Object)username, (Object)"GBIF");
        return new Authorizer(username, "GBIF");
    }

    public class Authorizer
    implements SecurityContext {
        private final UserPrincipal principal;
        private final String authenticationScheme;

        public Authorizer() {
            this.principal = null;
            this.authenticationScheme = "";
        }

        public Authorizer(String username, String authenticationScheme) {
            if (AuthFilter.this.userService == null) {
                LOG.debug("No user service configured! No roles assigned, using anonymous user instead.");
                this.principal = null;
            } else {
                User user = AuthFilter.this.userService.get(username);
                if (user == null) {
                    this.principal = null;
                    LOG.debug("Authorized user {} not found in user service! No roles could be assigned, using anonymous user instead.", (Object)username);
                } else {
                    this.principal = new UserPrincipal(user);
                }
            }
            this.authenticationScheme = authenticationScheme;
        }

        public Authorizer(User user, String scheme) {
            this.principal = new UserPrincipal(user);
            this.authenticationScheme = scheme;
        }

        public String getAuthenticationScheme() {
            return this.authenticationScheme;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isSecure() {
            return "https".equals(AuthFilter.this.uriInfo.getRequestUri().getScheme());
        }

        public boolean isUserInRole(String role) {
            return this.principal != null && this.principal.hasRole(role);
        }
    }
}

