/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.server.filter;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.model.common.AppPrincipal;
import org.gbif.api.model.common.ExtendedPrincipal;
import org.gbif.api.vocabulary.AppRole;
import org.gbif.ws.security.GbifAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppIdentityFilter
implements ContainerRequestFilter {
    public static final String APPKEYS_WHITELIST = "identity.appkeys.whitelist";
    private static final String GBIF_SCHEME_PREFIX = "GBIF ";
    private static final Logger LOG = LoggerFactory.getLogger(AppIdentityFilter.class);
    private final GbifAuthService authService;
    private final List<String> appKeyWhitelist;

    @Inject
    public AppIdentityFilter(@NotNull GbifAuthService authService, @Nullable @Named(value="identity.appkeys.whitelist") List<String> appKeyWhitelist) {
        this.authService = authService;
        this.appKeyWhitelist = appKeyWhitelist != null ? new ArrayList<String>(appKeyWhitelist) : new ArrayList();
    }

    public ContainerRequest filter(final ContainerRequest containerRequest) {
        if (containerRequest.getSecurityContext() != null && containerRequest.getUserPrincipal() != null) {
            return containerRequest;
        }
        String authorization = containerRequest.getHeaderValue("Authorization");
        if (StringUtils.startsWith((CharSequence)authorization, (CharSequence)GBIF_SCHEME_PREFIX)) {
            if (!this.authService.isValidRequest(containerRequest)) {
                LOG.warn("Invalid GBIF authenticated request");
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            String username = containerRequest.getHeaderValue("x-gbif-user");
            final String appKey = GbifAuthService.getAppKeyFromRequest(arg_0 -> ((ContainerRequest)containerRequest).getHeaderValue(arg_0));
            if (StringUtils.equals((CharSequence)appKey, (CharSequence)username) && this.appKeyWhitelist.contains(appKey)) {
                containerRequest.setSecurityContext(new SecurityContext(){
                    private final ExtendedPrincipal principal;
                    {
                        this.principal = new AppPrincipal(appKey, AppRole.APP.name());
                    }

                    public Principal getUserPrincipal() {
                        return this.principal;
                    }

                    public boolean isUserInRole(String s) {
                        return this.principal.hasRole(s);
                    }

                    public boolean isSecure() {
                        return containerRequest.isSecure();
                    }

                    public String getAuthenticationScheme() {
                        return "GBIF";
                    }
                });
            }
        }
        return containerRequest;
    }
}

