/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.mixin;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.gbif.api.model.occurrence.Download;
import org.gbif.api.model.occurrence.Occurrence;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.search.DatasetSearchResult;
import org.gbif.ws.mixin.DatasetMixin;
import org.gbif.ws.mixin.LicenseMixin;

public class Mixins {
    private static final ImmutableMap<Class<?>, Class<?>> PREDEFINED_MIXINS = ImmutableMap.of(Dataset.class, DatasetMixin.class, DatasetSearchResult.class, DatasetMixin.class, Download.class, LicenseMixin.class, Occurrence.class, LicenseMixin.class);

    private Mixins() {
    }

    public static Map<Class<?>, Class<?>> getPredefinedMixins() {
        return PREDEFINED_MIXINS;
    }

    public static Map<Class<?>, Class<?>> getPredefinedMixins(Predicate<Class<?>> keyFilter) {
        return ImmutableMap.copyOf((Map)Maps.filterKeys(PREDEFINED_MIXINS, keyFilter));
    }
}

