/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.json;

import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Provider
@Produces(value={"application/json"})
@Singleton
public class JacksonJsonContextResolver
implements ContextResolver<ObjectMapper> {
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    public static void addMixIns(Map<Class<?>, Class<?>> mixIns) {
        for (Map.Entry<Class<?>, Class<?>> classClassEntry : mixIns.entrySet()) {
            MAPPER.getSerializationConfig().addMixInAnnotations(classClassEntry.getKey(), classClassEntry.getValue());
            MAPPER.getDeserializationConfig().addMixInAnnotations(classClassEntry.getKey(), classClassEntry.getValue());
        }
    }

    public static void disableFeature(List<SerializationConfig.Feature> features) {
        if (features == null) {
            return;
        }
        features.stream().forEach(f -> MAPPER.configure(f, false));
    }

    public ObjectMapper getContext(Class<?> type) {
        return MAPPER;
    }

    static {
        MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        MAPPER.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        MAPPER.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

