/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client.interceptor;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.security.AccessControlException;
import javax.validation.ValidationException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.gbif.api.exception.ServiceUnavailableException;

public class HttpErrorResponseInterceptor
implements MethodInterceptor {
    private static String readBody(UniformInterfaceException e) {
        String status = "HTTP " + e.getResponse().getStatus() + ": ";
        try {
            return status + (String)e.getResponse().getEntity(String.class);
        }
        catch (Exception e1) {
            return status + "Failed to read http body";
        }
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = null;
        UniformInterfaceException e = null;
        try {
            result = invocation.proceed();
        }
        catch (UniformInterfaceException e2) {
            e = e2;
        }
        if (result instanceof UniformInterfaceException) {
            e = (UniformInterfaceException)((Object)result);
        }
        if (e != null) {
            ClientResponse response = e.getResponse();
            UniformInterfaceException eX = new UniformInterfaceException(HttpErrorResponseInterceptor.readBody(e), e.getResponse());
            switch (response.getStatus()) {
                case 204: {
                    return null;
                }
                case 400: {
                    throw new IllegalArgumentException("A bad request received.", eX);
                }
                case 401: {
                    throw new AccessControlException("Unauthorized request received.");
                }
                case 403: {
                    throw new AccessControlException("Forbidden request received.");
                }
                case 404: {
                    return null;
                }
                case 422: {
                    throw new ValidationException((Throwable)eX);
                }
                case 500: {
                    throw new ServiceUnavailableException("An internal server error occurred, please try again later.", (Throwable)eX);
                }
                case 501: {
                    throw new UnsupportedOperationException("Method not implement yet.", eX);
                }
            }
            throw eX;
        }
        return result;
    }
}

