/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client.guice;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.http.client.HttpClient;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.gbif.utils.HttpUtil;
import org.gbif.ws.client.BaseWsGetClient;
import org.gbif.ws.client.interceptor.HttpErrorResponseInterceptor;
import org.gbif.ws.client.interceptor.PublicMethodMatcher;
import org.gbif.ws.json.JacksonJsonContextResolver;

public abstract class GbifWsClientModule
extends PrivateModule {
    private final Properties properties;
    private final Set<Package> clientPackages;
    protected static final int DEFAULT_HTTP_TIMEOUT_MSECS = 10000;
    protected static final int DEFAULT_MAX_HTTP_CONNECTIONS = 100;
    protected static final int DEFAULT_MAX_HTTP_CONNECTIONS_PER_ROUTE = 100;

    protected GbifWsClientModule(Properties properties, Package ... clientPackages) {
        this.properties = properties;
        this.clientPackages = Sets.newHashSet((Object[])clientPackages);
        this.clientPackages.add(BaseWsGetClient.class.getPackage());
    }

    protected final void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.properties);
        JacksonJsonContextResolver.addMixIns(this.getMixIns());
        this.configureClient();
        for (Package clientPackage : this.clientPackages) {
            this.bindInterceptor(Matchers.inPackage((Package)clientPackage), (Matcher)new PublicMethodMatcher(), new MethodInterceptor[]{new HttpErrorResponseInterceptor()});
        }
    }

    protected abstract void configureClient();

    protected Map<Class<?>, Class<?>> getMixIns() {
        return Maps.newHashMap();
    }

    protected Properties getProperties() {
        return this.properties;
    }

    @Provides
    @Singleton
    public HttpClient provideHttpClient() {
        int httpTimeout = 10000;
        int maxHttpConnections = 100;
        int maxHttpConnectionsPerRoute = 100;
        if (this.properties.containsKey("httpTimeout")) {
            httpTimeout = Integer.parseInt(this.properties.getProperty("httpTimeout"));
        }
        if (this.properties.containsKey("maxHttpConnections")) {
            maxHttpConnections = Integer.parseInt(this.properties.getProperty("maxHttpConnections"));
        }
        if (this.properties.containsKey("maxHttpConnectionsPerRoute")) {
            maxHttpConnectionsPerRoute = Integer.parseInt(this.properties.getProperty("maxHttpConnectionsPerRoute"));
        }
        return HttpUtil.newMultithreadedClient((int)httpTimeout, (int)maxHttpConnections, (int)maxHttpConnectionsPerRoute);
    }

    @Provides
    @Singleton
    @Inject
    public Client providesJerseyClient(HttpClient client) {
        return GbifWsClientModule.buildJerseyClient(client);
    }

    public static Client buildJerseyClient(HttpClient client) {
        ApacheHttpClient4Handler hch = new ApacheHttpClient4Handler(client, null, false);
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJsonContextResolver.class);
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        return new ApacheHttpClient4(hch, (ClientConfig)clientConfig);
    }

    public static class HttpClientConnParams {
        public static final String HTTP_TIMEOUT = "httpTimeout";
        public static final String MAX_HTTP_CONNECTIONS = "maxHttpConnections";
        public static final String MAX_HTTP_CONNECTIONS_PER_ROUTE = "maxHttpConnectionsPerRoute";
    }
}

