/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client.guice;

import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.gbif.ws.util.spring.AnnotationUtils;

public class GbifMatchers {
    private GbifMatchers() {
    }

    public static Matcher<AnnotatedElement> annotatedWith(Class<? extends Annotation> annotationType) {
        return new AnnotatedWithType(annotationType);
    }

    private static void checkForRuntimeRetention(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        GbifMatchers.checkArgument(retention != null && retention.value() == RetentionPolicy.RUNTIME, "Annotation " + annotationType.getSimpleName() + " is missing RUNTIME retention");
    }

    private static void checkArgument(boolean b, String s) {
        if (!b) {
            throw new IllegalArgumentException(s);
        }
    }

    private static Class<? extends Annotation> checkNotNull(Class<? extends Annotation> arg, String s) {
        if (arg == null) {
            throw new IllegalArgumentException(s);
        }
        return arg;
    }

    private static class AnnotatedWithType
    extends AbstractMatcher<AnnotatedElement>
    implements Serializable {
        private final Class<? extends Annotation> annotationType;
        private static final long serialVersionUID = 0L;

        public AnnotatedWithType(Class<? extends Annotation> annotationType) {
            this.annotationType = GbifMatchers.checkNotNull(annotationType, "annotation type");
            GbifMatchers.checkForRuntimeRetention(annotationType);
        }

        public boolean matches(AnnotatedElement element) {
            Method m;
            if (element instanceof Method && (m = (Method)element).isBridge()) {
                return AnnotationUtils.getAnnotation(m, this.annotationType) != null;
            }
            return element.getAnnotation(this.annotationType) != null;
        }

        public boolean equals(Object other) {
            return other instanceof AnnotatedWithType && ((AnnotatedWithType)other).annotationType.equals(this.annotationType);
        }

        public int hashCode() {
            return 37 * this.annotationType.hashCode();
        }

        public String toString() {
            return "annotatedWith(" + this.annotationType.getSimpleName() + ".class)";
        }
    }
}

