/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client.guice;

import com.google.inject.AbstractModule;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Properties;
import org.gbif.ws.client.filter.HttpGbifAuthFilter;
import org.gbif.ws.client.filter.SimplePrincipalProvider;
import org.gbif.ws.security.GbifAuthService;

public class GbifApplicationAuthModule
extends AbstractModule {
    public static final String PROPERTY_APP_KEY = "application.key";
    public static final String PROPERTY_APP_SECRET = "application.secret";
    private final SimplePrincipalProvider pp = new SimplePrincipalProvider();
    private final GbifAuthService authService;

    public GbifApplicationAuthModule(String appKey, String appSecretKey) {
        this.authService = GbifAuthService.singleKeyAuthService(appKey, appSecretKey);
        this.pp.setPrincipal(appKey);
    }

    public GbifApplicationAuthModule(Properties properties) {
        this(properties.getProperty(PROPERTY_APP_KEY), properties.getProperty(PROPERTY_APP_SECRET));
    }

    protected void configure() {
        this.bind(SimplePrincipalProvider.class).toInstance((Object)this.pp);
        this.bind(GbifAuthService.class).toInstance((Object)this.authService);
        HttpGbifAuthFilter authFilter = new HttpGbifAuthFilter(this.authService, this.pp);
        this.bind(ClientFilter.class).toInstance((Object)authFilter);
    }

    public void setPrincipal(String username) {
        this.pp.setPrincipal(username);
    }
}

