/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client.filter;

import com.google.inject.Provider;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.security.Principal;
import org.gbif.ws.security.GbifAuthService;

public final class HttpGbifAuthFilter
extends ClientFilter {
    private final Provider<Principal> principalProvider;
    private final GbifAuthService authService;

    public HttpGbifAuthFilter(GbifAuthService authService, Provider<Principal> principalProvider) {
        this.principalProvider = principalProvider;
        this.authService = authService;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        Principal prince;
        if (this.principalProvider != null && (prince = (Principal)this.principalProvider.get()) != null) {
            this.authService.signRequest(prince.getName(), cr);
        }
        return this.getNext().handle(cr);
    }
}

