/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client;

import com.google.common.base.Strings;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.Language;

public class QueryParamBuilder {
    private final MultivaluedMap<String, String> params = new MultivaluedMapImpl();

    public static QueryParamBuilder create() {
        return new QueryParamBuilder();
    }

    public static QueryParamBuilder create(Object ... kvp) {
        if (kvp.length % 2 != 0) {
            throw new IllegalArgumentException("Equal number of kvp parameter required to build key value pairs.");
        }
        QueryParamBuilder builder = new QueryParamBuilder();
        for (int x = kvp.length - 1; x > 0; x -= 2) {
            Object k = kvp[x - 1];
            Object v = kvp[x];
            builder.queryParam(k, v);
        }
        return builder;
    }

    public static QueryParamBuilder create(String key, Object[] values) {
        return new QueryParamBuilder().queryParam(key, values);
    }

    public static QueryParamBuilder create(Map<String, String> fromParams) {
        QueryParamBuilder builder = new QueryParamBuilder();
        for (Map.Entry<String, String> kvp : fromParams.entrySet()) {
            builder.queryParam(kvp.getKey(), kvp.getValue());
        }
        return builder;
    }

    public QueryParamBuilder queryParam(Object key, Object ... value) {
        String k;
        if (key != null && value != null && !Strings.isNullOrEmpty((String)(k = key.toString()))) {
            for (Object val : value) {
                String v;
                if (val == null || Strings.isNullOrEmpty((String)(v = val instanceof Country ? ((Country)val).getIso2LetterCode() : (val instanceof Language ? ((Language)val).getIso2LetterCode() : val.toString())))) continue;
                this.params.add((Object)k, (Object)v);
            }
        }
        return this;
    }

    public MultivaluedMap<String, String> build() {
        return this.params;
    }
}

