/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.annotation.Nullable;
import javax.ws.rs.core.MultivaluedMap;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.search.SearchRequest;
import org.gbif.api.model.common.search.SearchResponse;
import org.gbif.ws.client.BaseWsClient;

public abstract class BaseWsSearchClient<T, P extends Enum<?>, R extends SearchRequest<P>>
extends BaseWsClient {
    private final GenericType<SearchResponse<T, P>> gType;

    protected BaseWsSearchClient(WebResource resource, GenericType<SearchResponse<T, P>> gType) {
        super(resource);
        this.gType = gType;
    }

    public SearchResponse<T, P> search(@Nullable R searchRequest) {
        return this.get(this.gType, null, this.getParameterFromRequest(searchRequest), (Pageable)searchRequest, "search");
    }

    protected MultivaluedMap<String, String> getParameterFromRequest(@Nullable R searchRequest) {
        return this.getParameterFromSearchRequest((SearchRequest<P>)searchRequest);
    }

    protected MultivaluedMap<String, String> getParameterFromSearchRequest(@Nullable SearchRequest<P> searchRequest) {
        MultivaluedMapImpl parameters = new MultivaluedMapImpl();
        if (searchRequest == null) {
            parameters.putSingle((Object)"q", (Object)"*");
        } else {
            String searchParamValue = searchRequest.getQ();
            if (Strings.isNullOrEmpty((String)searchParamValue)) {
                searchParamValue = "*";
            }
            parameters.putSingle((Object)"q", (Object)searchParamValue);
            parameters.putSingle((Object)"hl", (Object)Boolean.toString(searchRequest.isHighlight()));
            parameters.putSingle((Object)"spellCheck", (Object)Boolean.toString(searchRequest.isSpellCheck()));
            parameters.putSingle((Object)"spellCheckCount", (Object)Integer.toString(searchRequest.getSpellCheckCount()));
            Multimap requestParameters = searchRequest.getParameters();
            if (requestParameters != null) {
                for (Enum param : requestParameters.keySet()) {
                    parameters.put((Object)param.name(), (Object)Lists.newArrayList((Iterable)requestParameters.get((Object)param)));
                }
            }
        }
        return parameters;
    }
}

