/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client;

import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Locale;
import javax.annotation.Nullable;
import org.gbif.ws.client.BaseWsClient;

public abstract class BaseWsGetClient<T, K>
extends BaseWsClient {
    protected final Class<T> resourceClass;

    protected BaseWsGetClient(Class<T> resourceClass, WebResource resource, @Nullable ClientFilter authFilter) {
        super(resource);
        this.resourceClass = resourceClass;
        if (authFilter != null) {
            this.resource.addFilter(authFilter);
        }
    }

    @Nullable
    public T get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        return (T)this.resource.path(key.toString()).type("application/json").get(this.resourceClass);
    }

    @Nullable
    protected T get(String ... path) {
        return (T)this.getResource(path).type("application/json").get(this.resourceClass);
    }

    @Nullable
    protected T get(K key, Locale locale) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        return this.get(locale, key.toString());
    }

    @Nullable
    protected T get(Locale locale, String ... path) {
        WebResource.Builder res = this.getResource(path).type("application/json");
        if (locale != null) {
            res = (WebResource.Builder)res.acceptLanguage(new Locale[]{locale});
        }
        return (T)res.get(this.resourceClass);
    }
}

