/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import javax.annotation.Nullable;
import javax.ws.rs.core.MultivaluedMap;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.search.FacetedSearchRequest;
import org.gbif.api.model.common.search.SearchParameter;
import org.gbif.api.model.common.search.SearchResponse;
import org.gbif.api.service.common.SearchService;
import org.gbif.ws.client.BaseWsSearchClient;

public abstract class BaseWsFacetedSearchClient<T, P extends Enum<?>, R extends FacetedSearchRequest<P>>
extends BaseWsSearchClient<T, P, R>
implements SearchService<T, P, R> {
    protected BaseWsFacetedSearchClient(WebResource resource, GenericType<SearchResponse<T, P>> gType) {
        super(resource, gType);
    }

    @Override
    protected MultivaluedMap<String, String> getParameterFromRequest(@Nullable R searchRequest) {
        MultivaluedMap<String, String> parameters = super.getParameterFromRequest(searchRequest);
        if (searchRequest != null) {
            parameters.putSingle((Object)"facetMultiselect", (Object)Boolean.toString(searchRequest.isMultiSelectFacets()));
            if (searchRequest.getFacetMinCount() != null) {
                parameters.putSingle((Object)"facetMincount", (Object)Integer.toString(searchRequest.getFacetMinCount()));
            }
            if (searchRequest.getFacetLimit() != null) {
                parameters.putSingle((Object)"facetLimit", (Object)Integer.toString(searchRequest.getFacetLimit()));
            }
            if (searchRequest.getFacetOffset() != null) {
                parameters.putSingle((Object)"facetOffset", (Object)Integer.toString(searchRequest.getFacetOffset()));
            }
            if (searchRequest.getFacets() != null) {
                for (Enum facet : searchRequest.getFacets()) {
                    parameters.add((Object)"facet", (Object)facet.name());
                    Pageable facetPage = searchRequest.getFacetPage((SearchParameter)facet);
                    if (facetPage == null) continue;
                    parameters.add((Object)(facet.name() + '.' + "facetOffset"), (Object)Long.toString(facetPage.getOffset()));
                    parameters.add((Object)(facet.name() + '.' + "facetLimit"), (Object)Long.toString(facetPage.getLimit()));
                }
            }
        }
        return parameters;
    }
}

