/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ws.client;

import com.google.common.base.Joiner;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.ws.json.JacksonJsonContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWsClient {
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    protected final WebResource resource;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper = new JacksonJsonContextResolver().getContext(null);

    public BaseWsClient(WebResource resource) {
        this.resource = resource;
        this.log.info("Creating new {} using webservices at {}", (Object)this.getClass().getSimpleName(), (Object)resource.toString());
    }

    protected WebResource getResource() {
        return this.resource;
    }

    protected WebResource getResource(@Nullable Pageable page) {
        return this.applyPage(this.resource, page);
    }

    protected WebResource applyPage(WebResource resource, @Nullable Pageable page) {
        if (page == null) {
            return resource;
        }
        return resource.queryParam("limit", String.valueOf(page.getLimit())).queryParam("offset", String.valueOf(page.getOffset()));
    }

    protected WebResource getResource(String ... path) {
        return this.getResource((Pageable)null, path);
    }

    protected WebResource getResource(Pageable page, String ... path) {
        return this.getResource(page).path(PATH_JOINER.join((Object[])path));
    }

    protected WebResource getResource(@Nullable Pageable page, @Nullable MultivaluedMap<String, String> params, String ... path) {
        WebResource res = this.getResource(page, path);
        if (params != null) {
            return res.queryParams(params);
        }
        return res;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.resource + '}';
    }

    protected <T> T get(GenericType<T> gt, String ... path) {
        return this.get(gt, (Locale)null, (MultivaluedMap<String, String>)null, (Pageable)null, path);
    }

    protected <T> T get(GenericType<T> gt, Pageable page, String ... path) {
        return this.get(gt, null, null, page, path);
    }

    protected <T> T get(GenericType<T> gt, MultivaluedMap<String, String> params, String ... path) {
        return this.get(gt, null, params, null, path);
    }

    protected <T> T get(GenericType<T> gt, @Nullable Locale locale, @Nullable MultivaluedMap<String, String> params, @Nullable Pageable page, String ... path) {
        WebResource res = this.getResource(page, params, path);
        if (locale == null) {
            return (T)res.type("application/json").get(gt);
        }
        return (T)((WebResource.Builder)res.type("application/json").acceptLanguage(new Locale[]{locale})).get(gt);
    }

    protected <T> T get(GenericType<T> gt, Pageable page, WebResource resource) {
        return (T)this.applyPage(resource, page).type("application/json").get(gt);
    }

    protected byte[] toBytes(Object entity) {
        try {
            return this.mapper.writeValueAsBytes(entity);
        }
        catch (IOException e) {
            this.log.error("Failed to serialize http entity [{}]", entity);
            throw new IllegalStateException(e);
        }
    }

    protected void post(Object entity, String ... path) {
        this.getResource(path).type("application/json").post((Object)this.toBytes(entity));
    }

    protected <T> T post(GenericType<T> gt, Object entity, String ... path) {
        return (T)this.getResource(path).type("application/json").post(gt, (Object)this.toBytes(entity));
    }

    protected <T> T post(Class<T> cl, Object entity, String ... path) {
        return (T)this.getResource(path).type("application/json").post(cl, (Object)this.toBytes(entity));
    }

    protected void put(Object entity, String ... path) {
        this.getResource(path).type("application/json").put((Object)this.toBytes(entity));
    }

    protected <T> T put(GenericType<T> gt, Object entity, String ... path) {
        return (T)this.getResource(path).type("application/json").put(gt, (Object)this.toBytes(entity));
    }

    protected <T> T put(Class<T> cl, Object entity, String ... path) {
        return (T)this.getResource(path).type("application/json").put(cl, (Object)this.toBytes(entity));
    }

    protected void delete(String ... path) {
        this.getResource(path).type("application/json").delete();
    }
}

