/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.surety.persistence;

import java.util.Optional;
import java.util.UUID;
import org.gbif.registry.surety.model.ChallengeCode;
import org.gbif.registry.surety.persistence.ChallengeCodeMapper;
import org.gbif.registry.surety.persistence.ChallengeCodeSupportMapper;

public class ChallengeCodeManager<K> {
    private final ChallengeCodeMapper challengeCodeMapper;
    private final ChallengeCodeSupportMapper<K> challengeCodeSupportMapper;

    public ChallengeCodeManager(ChallengeCodeMapper challengeCodeMapper, ChallengeCodeSupportMapper<K> challengeCodeSupportMapper) {
        this.challengeCodeMapper = challengeCodeMapper;
        this.challengeCodeSupportMapper = challengeCodeSupportMapper;
    }

    public boolean isValidChallengeCode(K key, UUID challengeCode) {
        if (key == null || challengeCode == null) {
            return false;
        }
        Integer ccKey = this.challengeCodeSupportMapper.getChallengeCodeKey(key);
        return ccKey != null && challengeCode.equals(this.challengeCodeMapper.getChallengeCode(ccKey));
    }

    public boolean hasChallengeCode(K key) {
        return Optional.ofNullable(this.challengeCodeSupportMapper.getChallengeCodeKey(key)).isPresent();
    }

    public ChallengeCode create(K key) {
        ChallengeCode challengeCode = ChallengeCode.newRandom();
        this.challengeCodeMapper.createChallengeCode(challengeCode);
        this.challengeCodeSupportMapper.updateChallengeCodeKey(key, challengeCode.getKey());
        return challengeCode;
    }

    public boolean remove(K key) {
        return Optional.ofNullable(this.challengeCodeSupportMapper.getChallengeCodeKey(key)).map(challengeCodeKey -> {
            this.challengeCodeSupportMapper.updateChallengeCodeKey(key, null);
            this.challengeCodeMapper.deleteChallengeCode((int)challengeCodeKey);
            return true;
        }).orElse(Boolean.FALSE);
    }
}

