/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.surety.email;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gbif.registry.surety.email.BaseEmailModel;

public class EmailTemplateProcessor {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final Configuration FREEMARKER_CONFIG = new Configuration(Configuration.VERSION_2_3_25);
    private final Function<Locale, String> subjectProvider;
    private final Function<Locale, String> templateFileProvider;

    public EmailTemplateProcessor(Function<Locale, String> subjectProvider, Function<Locale, String> templateFileProvider) {
        this.subjectProvider = subjectProvider;
        this.templateFileProvider = templateFileProvider;
    }

    public BaseEmailModel buildEmail(String emailAddress, Object templateDataModel, @Nullable Locale locale) throws IOException, TemplateException {
        return this.buildEmail(emailAddress, templateDataModel, locale, null);
    }

    public BaseEmailModel buildEmail(String emailAddress, Object templateDataModel, @Nullable Locale locale, List<String> ccAddresses) throws IOException, TemplateException {
        Objects.requireNonNull(emailAddress, "emailAddress shall be provided");
        Objects.requireNonNull(templateDataModel, "templateDataModel shall be provided");
        Locale emailLocale = Optional.ofNullable(locale).orElse(DEFAULT_LOCALE);
        StringWriter contentBuffer = new StringWriter();
        FREEMARKER_CONFIG.getTemplate(this.templateFileProvider.apply(emailLocale)).process(templateDataModel, (Writer)contentBuffer);
        return new BaseEmailModel(emailAddress, this.subjectProvider.apply(emailLocale), contentBuffer.toString(), ccAddresses);
    }

    static {
        FREEMARKER_CONFIG.setDefaultEncoding("UTF-8");
        FREEMARKER_CONFIG.setLocale(Locale.US);
        FREEMARKER_CONFIG.setNumberFormat("0.####");
        FREEMARKER_CONFIG.setDateFormat("yyyy-mm-dd");
        FREEMARKER_CONFIG.setClassForTemplateLoading(EmailTemplateProcessor.class, "/email");
    }
}

