/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.surety.email;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.gbif.registry.surety.SuretyConstants;
import org.gbif.registry.surety.email.BaseEmailModel;
import org.gbif.registry.surety.email.EmailManagerConfiguration;
import org.gbif.registry.surety.email.EmailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmailSenderImpl
implements EmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(EmailSenderImpl.class);
    private static final Splitter EMAIL_SPLITTER = Splitter.on((char)';').omitEmptyStrings().trimResults();
    private static final String HTML_CONTENT_TYPE = "text/html; charset=UTF-8";
    private final Session session;
    private final Set<Address> bccAddresses;

    @Inject
    EmailSenderImpl(EmailManagerConfiguration config) {
        this.session = config.getSession();
        this.bccAddresses = Optional.ofNullable(config.getBccAddresses()).map(bccAddresses -> EmailSenderImpl.toInternetAddresses(EMAIL_SPLITTER.split((CharSequence)bccAddresses))).orElse(Collections.emptySet());
    }

    @Override
    public void send(BaseEmailModel emailModel) {
        Objects.requireNonNull(emailModel, "emailModel shall be provided");
        Objects.requireNonNull(emailModel.getEmailAddress(), "emailAddress shall be provided");
        EmailSenderImpl.toAddress(emailModel.getEmailAddress()).ifPresent(emailAddress -> {
            try {
                MimeMessage msg = new MimeMessage(this.session);
                msg.setFrom();
                msg.setRecipient(Message.RecipientType.TO, emailAddress);
                msg.setRecipients(Message.RecipientType.BCC, EmailSenderImpl.generateBccArray(this.bccAddresses, emailModel));
                msg.setSubject(emailModel.getSubject());
                msg.setSentDate(new Date());
                msg.setContent((Object)emailModel.getBody(), HTML_CONTENT_TYPE);
                Transport.send((Message)msg);
            }
            catch (MessagingException e) {
                LOG.error(SuretyConstants.NOTIFY_ADMIN, "Sending of notification Mail for [{}] failed", emailAddress, (Object)e);
            }
        });
    }

    private static Set<Address> toInternetAddresses(Iterable<String> strEmails) {
        return StreamSupport.stream(strEmails.spliterator(), false).map(EmailSenderImpl::toAddress).flatMap(address -> address.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toSet());
    }

    @VisibleForTesting
    static Address[] generateBccArray(Set<Address> bccAddressesFromConfig, BaseEmailModel emailModel) {
        HashSet<Address> combinedBccAddresses = new HashSet<Address>(bccAddressesFromConfig);
        Optional.ofNullable(emailModel.getCcAddress()).ifPresent(bccList -> bccList.forEach(bcc -> EmailSenderImpl.toAddress(bcc).ifPresent(combinedBccAddresses::add)));
        return combinedBccAddresses.toArray(new Address[combinedBccAddresses.size()]);
    }

    @VisibleForTesting
    static Optional<Address> toAddress(String emailAddress) {
        try {
            return Optional.of(new InternetAddress(emailAddress));
        }
        catch (AddressException e) {
            LOG.warn("Ignore corrupt email address {}", (Object)emailAddress);
            return Optional.empty();
        }
    }
}

