/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.surety.email;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.util.Properties;
import javax.mail.Session;
import org.gbif.registry.surety.email.EmailManagerConfiguration;
import org.gbif.registry.surety.email.EmailSender;
import org.gbif.registry.surety.email.EmailSenderImpl;
import org.gbif.utils.file.properties.PropertiesUtil;

public class EmailManagerModule
extends AbstractModule {
    private static final String PROPERTY_PREFIX = "mail.";
    private static final String SMTP_SERVER = "smtp.host";
    private static final String EMAIL_FROM = "from";
    private static final String EMAIL_BCC = "bcc";
    private final Properties filteredProperties;

    public EmailManagerModule(Properties properties) {
        this.filteredProperties = PropertiesUtil.filterProperties((Properties)properties, (String)PROPERTY_PREFIX);
    }

    protected void configure() {
        this.bind(EmailSender.class).to(EmailSenderImpl.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    private EmailManagerConfiguration provideIdentityEmailManagerConfiguration() {
        EmailManagerConfiguration config = new EmailManagerConfiguration();
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.filteredProperties.getProperty(SMTP_SERVER));
        props.setProperty("mail.from", this.filteredProperties.getProperty(EMAIL_FROM));
        config.setSession(Session.getInstance((Properties)props, null));
        config.setBccAddresses(this.filteredProperties.getProperty(EMAIL_BCC));
        return config;
    }
}

