/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.doi.service.ezid;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.common.DoiData;
import org.gbif.api.model.common.DoiStatus;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.service.BaseService;
import org.gbif.doi.service.DoiException;
import org.gbif.doi.service.DoiExistsException;
import org.gbif.doi.service.DoiHttpException;
import org.gbif.doi.service.ServiceConfig;
import org.gbif.doi.service.datacite.DataCiteValidator;
import org.gbif.doi.service.ezid.AnvlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EzidService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(EzidService.class);
    private static final URI DEFAULT_API = URI.create("https://ezid.cdlib.org/");
    private static final String NON_TARGET = "http://ezid.cdlib.org/id";
    private final URI apiWs;
    private final URI idWs;

    public EzidService(CloseableHttpClient httpClient, ServiceConfig cfg) {
        super(httpClient, cfg);
        this.apiWs = cfg.getApi() == null ? DEFAULT_API : cfg.getApi();
        this.idWs = this.apiWs.resolve("id/");
    }

    @VisibleForTesting
    protected URI idUri(DOI doi) throws DoiException {
        try {
            return URI.create(this.idWs.toString() + doi);
        }
        catch (IllegalArgumentException e) {
            throw new DoiException("Unable to convert DOI to EZID URI", e);
        }
    }

    @Override
    public DoiData resolve(DOI doi) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Map<String, String> meta = this.getANVL(doi);
        if (meta.containsKey("_status")) {
            URI target = null;
            String url = meta.get("_target");
            if (url != null && !url.toLowerCase().startsWith(NON_TARGET)) {
                try {
                    target = URI.create(meta.get("_target"));
                }
                catch (IllegalArgumentException e) {
                    LOG.debug("Invalid DOI URL", (Object)e.getMessage());
                }
            }
            return new DoiData(meta.get("_status"), target);
        }
        return null;
    }

    @Override
    public boolean exists(DOI doi) throws DoiException {
        Map<String, String> result = null;
        try {
            result = this.getANVL(doi);
        }
        catch (DoiHttpException e) {
            return false;
        }
        return result != null && !result.isEmpty();
    }

    @Override
    public String getMetadata(DOI doi) throws DoiException {
        throw new UnsupportedOperationException();
    }

    private Map<String, String> getANVL(DOI doi) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        try {
            return AnvlUtils.read(this.get(this.idUri(doi)));
        }
        catch (DoiHttpException e) {
            if (Math.round((double)e.getStatus() / 100.0) == 4L) {
                LOG.debug("Non existing DOI", (Object)e.getMessage());
                return Maps.newHashMap();
            }
            throw e;
        }
    }

    @Override
    public void reserve(DOI doi, String metadata) throws DoiException {
        DataCiteValidator.validateMetadata(metadata);
        this.reserveWithoutValidation(doi, metadata);
    }

    @Override
    public void reserve(DOI doi, DataCiteMetadata metadata) throws DoiException {
        this.reserveWithoutValidation(doi, DataCiteValidator.toXml(doi, metadata));
    }

    private void reserveWithoutValidation(DOI doi, String xml) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)xml);
        Map<String, String> data = AnvlUtils.builder().datacite(xml).status(DoiStatus.RESERVED).build();
        this.postOrPut(doi, data, (HttpEntityEnclosingRequestBase)new HttpPut(this.idUri(doi)));
        LOG.info("Reserved {}", (Object)doi);
    }

    @Override
    public void register(DOI doi, URI target, String metadata) throws DoiException {
        DataCiteValidator.validateMetadata(metadata);
        this.registerWithoutValidation(doi, target, metadata);
    }

    @Override
    public void register(DOI doi, URI target, DataCiteMetadata metadata) throws DoiException {
        this.registerWithoutValidation(doi, target, DataCiteValidator.toXml(doi, metadata));
    }

    private void registerWithoutValidation(DOI doi, URI target, String xml) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)target);
        DoiData status = this.resolve(doi);
        if (status == null) {
            this.reserve(doi, xml);
        } else if (DoiStatus.REGISTERED == status.getStatus()) {
            throw new DoiExistsException(doi);
        }
        Map<String, String> data = AnvlUtils.builder().target(target).datacite(xml).status(DoiStatus.REGISTERED).build();
        this.postOrPut(doi, data, (HttpEntityEnclosingRequestBase)new HttpPost(this.idUri(doi)));
        LOG.info("Registered {}", (Object)doi);
    }

    @Override
    public boolean delete(DOI doi) throws DoiException {
        DoiData status = this.resolve(doi);
        if (status != null) {
            if (DoiStatus.RESERVED == status.getStatus()) {
                this.delete(this.idUri(doi));
                LOG.info("Deleted {}", (Object)doi);
                return true;
            }
            Map<String, String> data = AnvlUtils.builder().target(null).status(DoiStatus.DELETED).build();
            this.postOrPut(doi, data, (HttpEntityEnclosingRequestBase)new HttpPost(this.idUri(doi)));
            LOG.info("Made {} unavailable", (Object)doi);
            return false;
        }
        throw new DoiException("DOI " + doi + " not existing");
    }

    @Override
    public void update(DOI doi, String metadata) throws DoiException {
        DataCiteValidator.validateMetadata(metadata);
        this.updateWithoutValidation(doi, metadata);
    }

    @Override
    public void update(DOI doi, DataCiteMetadata metadata) throws DoiException {
        this.updateWithoutValidation(doi, DataCiteValidator.toXml(doi, metadata));
    }

    private void updateWithoutValidation(DOI doi, String xml) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)xml);
        Map<String, String> data = AnvlUtils.builder().datacite(xml).build();
        this.postOrPut(doi, data, (HttpEntityEnclosingRequestBase)new HttpPost(this.idUri(doi)));
        LOG.info("Updated metadata for {}", (Object)doi);
    }

    @Override
    public void update(DOI doi, URI target) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)target);
        Map<String, String> data = AnvlUtils.builder().target(target).build();
        this.postOrPut(doi, data, (HttpEntityEnclosingRequestBase)new HttpPost(this.idUri(doi)));
        LOG.info("Updated metadata for {}", (Object)doi);
    }

    protected void postOrPut(DOI doi, Map<String, String> anvl, HttpEntityEnclosingRequestBase req) throws DoiException {
        if (anvl != null && !anvl.isEmpty()) {
            StringEntity entity = new StringEntity(AnvlUtils.write(anvl), PLAIN_TEXT_UTF8);
            req.setEntity((HttpEntity)entity);
            this.authCall((HttpUriRequest)req);
        }
    }
}

