/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.doi.service.ezid;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.gbif.api.model.common.DoiStatus;

public class AnvlUtils {
    public static final String TARGET = "_target";
    public static final String DATACITE = "datacite";
    public static final String STATUS = "_status";
    public static final String PROFILE = "_profile";
    public static final String CROSSREF = "_crossref";

    public static String write(Map<String, String> metadata) {
        StringBuffer buffer = new StringBuffer();
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                buffer.append(AnvlUtils.encode(entry.getKey()) + ": " + AnvlUtils.encode(entry.getValue()) + "\n");
            }
        }
        return buffer.toString();
    }

    private static String encode(String s) {
        return s.replace("%", "%25").replace("\n", "%0A").replace("\r", "%0D").replace(":", "%3A");
    }

    private static String decode(String s) {
        int i;
        StringBuffer b = new StringBuffer();
        while ((i = s.indexOf("%")) >= 0) {
            b.append(s.substring(0, i));
            b.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
            s = s.substring(i + 3);
        }
        b.append(s);
        return b.toString();
    }

    private static String[] parseAnvlLine(String line) {
        String[] kv = line.split(":", 2);
        kv[0] = AnvlUtils.decode(kv[0]).trim();
        kv[1] = AnvlUtils.decode(kv[1]).trim();
        return kv;
    }

    public static Map<String, String> read(InputStream is) throws IOException {
        return AnvlUtils.read(new BufferedReader(new InputStreamReader(is, Charsets.UTF_8)));
    }

    public static Map<String, String> read(Reader r) throws IOException {
        return AnvlUtils.read(new BufferedReader(r));
    }

    public static Map<String, String> read(String anvl) {
        try {
            return AnvlUtils.read(new BufferedReader(new StringReader(anvl)));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, String> read(BufferedReader br) throws IOException {
        String l;
        HashMap<String, String> d = new HashMap<String, String>();
        while ((l = br.readLine()) != null) {
            String[] kv = AnvlUtils.parseAnvlLine(l);
            d.put(kv[0], kv[1]);
        }
        return d;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, String> map = new HashMap<String, String>();

        public Builder target(URI target) {
            if (target == null) {
                this.map.put(AnvlUtils.TARGET, "");
            } else {
                this.map.put(AnvlUtils.TARGET, target.toString());
            }
            return this;
        }

        public Builder datacite(String datacite) {
            this.map.put(AnvlUtils.DATACITE, datacite);
            return this;
        }

        public Builder status(DoiStatus status) {
            this.map.put(AnvlUtils.STATUS, status.getEzid());
            return this;
        }

        public Builder entry(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Map<String, String> build() {
            return this.map;
        }
    }

    public static class Anvl {
        private String target;
        private String datacite;
        private String status;

        public Anvl(String target, String datacite, String status) {
            this.target = target;
            this.datacite = datacite;
            this.status = status;
        }
    }
}

