/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.doi.service.datacite;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.gbif.api.model.common.DOI;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.service.InvalidMetadataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DataCiteValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DataCiteValidator.class);
    private static final String DATACITE_XSD_LOCATION = "http://schema.datacite.org/meta/kernel-3/metadata.xsd";
    private static final String DATACITE_SCHEMA_LOCATION = "http://datacite.org/schema/kernel-3 http://schema.datacite.org/meta/kernel-3/metadata.xsd";
    private static Schema DATACITE_SCHEMA;
    private static final JAXBContext context;

    public static String toXml(DOI doi, DataCiteMetadata data) throws InvalidMetadataException {
        data.setIdentifier(DataCiteMetadata.Identifier.builder().withValue(doi.getDoiName()).withIdentifierType("DOI").build());
        StringWriter writer = new StringWriter();
        try {
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.schemaLocation", (Object)DATACITE_SCHEMA_LOCATION);
            m.marshal((Object)data, (Writer)writer);
            writer.flush();
        }
        catch (JAXBException e) {
            throw new InvalidMetadataException(e);
        }
        String xml = writer.toString();
        DataCiteValidator.validateMetadata(xml);
        LOG.debug("Metadata XML passed validation", (Object)doi);
        return xml;
    }

    public static DataCiteMetadata fromXml(String xml) throws JAXBException {
        return DataCiteValidator.fromXml(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8)));
    }

    public static DataCiteMetadata fromXml(InputStream in) throws JAXBException {
        Unmarshaller m = context.createUnmarshaller();
        return (DataCiteMetadata)m.unmarshal(in);
    }

    public static void validateMetadata(String xml) throws InvalidMetadataException {
        DataCiteValidator.validateMetadata(new StreamSource(new StringReader(xml)));
    }

    public static void validateMetadata(InputStream xml) throws InvalidMetadataException {
        DataCiteValidator.validateMetadata(new StreamSource(xml));
    }

    public static void validateMetadata(Source source) throws InvalidMetadataException {
        try {
            DataCiteValidator.getValidator().validate(source);
            LOG.debug("Metadata XML passed validation");
        }
        catch (SAXException e) {
            throw new InvalidMetadataException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Validator getValidator() throws IOException, SAXException {
        if (DATACITE_SCHEMA != null) return DATACITE_SCHEMA.newValidator();
        String string = DATACITE_SCHEMA_LOCATION;
        synchronized (DATACITE_SCHEMA_LOCATION) {
            if (DATACITE_SCHEMA != null) return DATACITE_SCHEMA.newValidator();
            String schemaLang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
            DATACITE_SCHEMA = factory.newSchema(new StreamSource(DATACITE_XSD_LOCATION));
            // ** MonitorExit[var0] (shouldn't be in output)
            return DATACITE_SCHEMA.newValidator();
        }
    }

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{DataCiteMetadata.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Fail to setup JAXB", e);
        }
    }
}

