/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.doi.service.datacite;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.common.DoiData;
import org.gbif.api.model.common.DoiStatus;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.service.BaseService;
import org.gbif.doi.service.DoiException;
import org.gbif.doi.service.DoiExistsException;
import org.gbif.doi.service.DoiHttpException;
import org.gbif.doi.service.ServiceConfig;
import org.gbif.doi.service.datacite.DataCiteValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCiteService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(DataCiteService.class);
    private static final ContentType APPLICATION_XML_UTF8 = ContentType.create((String)"application/xml", (Charset)Charsets.UTF_8);
    private static final URI DEFAULT_API = URI.create("https://mds.datacite.org/");
    private static final URI TEST_404_TARGET = URI.create("http://www.datacite.org/testprefix");
    private final URI apiWs;
    private final URI doiWs;
    private final URI metadataWs;

    public DataCiteService(CloseableHttpClient httpClient, ServiceConfig cfg) {
        super(httpClient, cfg);
        this.apiWs = cfg.getApi() == null ? DEFAULT_API : cfg.getApi();
        this.doiWs = this.apiWs.resolve("/doi/");
        this.metadataWs = this.apiWs.resolve("/metadata/");
    }

    @Override
    public DoiData resolve(DOI doi) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        try {
            URI target = this.getTargetUrl(doi);
            try {
                this.get(this.metadataUri(doi));
                return target == null ? new DoiData(DoiStatus.RESERVED, null) : new DoiData(DoiStatus.REGISTERED, target);
            }
            catch (DoiHttpException e) {
                if (e.getStatus() == 410) {
                    return new DoiData(DoiStatus.DELETED, target);
                }
            }
        }
        catch (DoiException e) {
            LOG.debug("Unknown error detecting DOI status", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public String getMetadata(DOI doi) throws DoiException {
        return this.get(this.metadataUri(doi));
    }

    private URI getTargetUrl(DOI doi) throws DoiHttpException {
        String content = null;
        try {
            URI target;
            content = this.get(this.doiUri(doi));
            if (!Strings.isNullOrEmpty((String)content) && !TEST_404_TARGET.equals(target = URI.create(content))) {
                return target;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("DataCite returned an invalid target URL {}", (Object)content, (Object)e.getMessage());
        }
        catch (DoiHttpException e) {
            if (Math.round((double)e.getStatus() / 100.0) == 4L) {
                throw e;
            }
            LOG.debug("Non existing DOI", (Object)e.getMessage());
        }
        catch (DoiException e) {
            LOG.debug("Non existing DOI", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public boolean exists(DOI doi) throws DoiException {
        try {
            this.get(this.metadataUri(doi));
        }
        catch (DoiHttpException e) {
            return false;
        }
        return true;
    }

    @Override
    public void reserve(DOI doi, String metadata) throws DoiException {
        DataCiteValidator.validateMetadata(metadata);
        this.reserveWithoutValidation(doi, metadata);
    }

    @Override
    public void reserve(DOI doi, DataCiteMetadata metadata) throws DoiException {
        this.reserveWithoutValidation(doi, DataCiteValidator.toXml(doi, metadata));
    }

    private void reserveWithoutValidation(DOI doi, String metadata) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)metadata);
        if (this.exists(doi)) {
            throw new DoiExistsException(doi);
        }
        this.post(doi, this.metadataWs, metadata);
        LOG.info("Reserved {}", (Object)doi);
    }

    @Override
    public void register(DOI doi, URI target, String metadata) throws DoiException {
        DataCiteValidator.validateMetadata(metadata);
        this.registerWithoutValidation(doi, target, metadata);
    }

    @Override
    public void register(DOI doi, URI target, DataCiteMetadata metadata) throws DoiException {
        this.registerWithoutValidation(doi, target, DataCiteValidator.toXml(doi, metadata));
    }

    private void registerWithoutValidation(DOI doi, URI target, String metadata) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)metadata);
        DoiData status = this.resolve(doi);
        if (status != null && DoiStatus.REGISTERED == status.getStatus()) {
            throw new DoiExistsException(doi);
        }
        this.post(doi, this.metadataWs, metadata);
        this.authCall((HttpUriRequest)this.buildDoiUrlPost(doi, target));
        if (status != null && DoiStatus.DELETED == status.getStatus()) {
            LOG.info("Re-registered {}", (Object)doi);
        } else {
            LOG.info("Registered {}", (Object)doi);
        }
    }

    @Override
    public boolean delete(DOI doi) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        this.delete(this.metadataUri(doi));
        LOG.info("Deleted {}", (Object)doi);
        return this.resolve(doi) != null;
    }

    @Override
    public void update(DOI doi, String metadata) throws DoiException {
        DataCiteValidator.validateMetadata(metadata);
        this.updateWithoutValidation(doi, metadata);
    }

    @Override
    public void update(DOI doi, DataCiteMetadata metadata) throws DoiException {
        this.updateWithoutValidation(doi, DataCiteValidator.toXml(doi, metadata));
    }

    private void updateWithoutValidation(DOI doi, String metadata) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)metadata);
        DoiData status = this.resolve(doi);
        if (status == null || DoiStatus.REGISTERED != status.getStatus()) {
            throw new DoiException("DOI was not registered yet");
        }
        this.post(doi, this.metadataWs, metadata);
        LOG.info("Updated metadata for {}", (Object)doi);
    }

    @Override
    public void update(DOI doi, URI target) throws DoiException {
        Preconditions.checkNotNull((Object)doi);
        Preconditions.checkNotNull((Object)target);
        DoiData status = this.resolve(doi);
        if (status == null || DoiStatus.REGISTERED != status.getStatus()) {
            throw new DoiException("DOI was not registered yet");
        }
        this.authCall((HttpUriRequest)this.buildDoiUrlPost(doi, target));
        LOG.info("Updated target URL for {}", (Object)doi);
    }

    private HttpPost buildDoiUrlPost(DOI doi, URI target) {
        HttpPost post = new HttpPost(this.doiWs);
        String body = String.format("doi=%s\nurl=%s", doi.getDoiName(), target);
        StringEntity entity = new StringEntity(body, PLAIN_TEXT_UTF8);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    @VisibleForTesting
    protected URI doiUri(DOI doi) throws DoiException {
        try {
            return URI.create(this.doiWs.toString() + doi.getDoiName());
        }
        catch (IllegalArgumentException e) {
            throw new DoiException("Unable to convert DOI to DataCite URI", e);
        }
    }

    @VisibleForTesting
    protected URI metadataUri(DOI doi) throws DoiException {
        try {
            return URI.create(this.metadataWs.toString() + doi.getDoiName());
        }
        catch (IllegalArgumentException e) {
            throw new DoiException("Unable to convert DOI to DataCite URI", e);
        }
    }

    private void post(DOI doi, URI uri, String metadata) throws DoiException {
        LOG.debug("POST: {}", (Object)uri);
        HttpPost req = new HttpPost(uri);
        StringEntity entity = new StringEntity(metadata, APPLICATION_XML_UTF8);
        req.setEntity((HttpEntity)entity);
        this.authCall((HttpUriRequest)req);
    }
}

