/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.doi.service;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.gbif.doi.service.DoiException;
import org.gbif.doi.service.DoiHttpException;
import org.gbif.doi.service.DoiService;
import org.gbif.doi.service.ServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseService
implements DoiService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseService.class);
    protected static final ContentType PLAIN_TEXT_UTF8 = ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8);
    private final CloseableHttpClient httpClient;
    private final CredentialsProvider credsProvider;

    protected BaseService(CloseableHttpClient httpClient, ServiceConfig cfg) {
        this.httpClient = httpClient;
        LOG.info("Setup DOI service using account {}", (Object)cfg.getUsername());
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(cfg.getUsername(), cfg.getPassword()));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String authCall(HttpUriRequest req) throws DoiException {
        String msg2222222;
        CloseableHttpResponse resp = null;
        try {
            resp = this.httpClient.execute(req, this.buildAuthContext());
            if (!BaseService.isSuccess((HttpResponse)resp)) {
                String msg2222222 = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)Charsets.UTF_8);
                LOG.debug("Received HTTP {} {}: {}", new Object[]{resp.getStatusLine().getStatusCode(), resp.getStatusLine().getReasonPhrase(), msg2222222});
                BaseService.closeSilently(resp);
                throw new DoiHttpException(resp.getStatusLine().getStatusCode(), msg2222222);
            }
            msg2222222 = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)Charsets.UTF_8);
        }
        catch (DoiException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new DoiException(e2);
                }
            }
            catch (Throwable throwable) {
                BaseService.closeSilently(resp);
                throw throwable;
            }
        }
        BaseService.closeSilently(resp);
        return msg2222222;
    }

    private static void closeSilently(CloseableHttpResponse resp) {
        if (resp != null) {
            try {
                resp.close();
            }
            catch (IOException e) {
                LOG.warn("Could not close http connection", (Throwable)e);
            }
        }
    }

    protected String get(URI uri) throws DoiException {
        return this.authCall((HttpUriRequest)new HttpGet(uri));
    }

    protected String delete(URI uri) throws DoiException {
        return this.authCall((HttpUriRequest)new HttpDelete(uri));
    }

    protected static boolean isSuccess(HttpResponse resp) {
        return Math.round((double)resp.getStatusLine().getStatusCode() / 100.0) == 2L;
    }

    private HttpContext buildAuthContext() {
        BasicHttpContext authContext = new BasicHttpContext();
        authContext.setAttribute("http.auth.credentials-provider", (Object)this.credsProvider);
        return authContext;
    }
}

