/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordEncoder.class);
    private static final String ALGORITHM = "SHA-512";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String PASSWORD_ITOA64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private final int encodedHashLength;

    public PasswordEncoder() {
        this.encodedHashLength = 55;
    }

    public PasswordEncoder(int hashLength) {
        this.encodedHashLength = hashLength;
    }

    private static int passwordGetCountLog2(String settings) {
        return PASSWORD_ITOA64.indexOf(settings.charAt(3));
    }

    private static byte[] sha512(String input) {
        return PasswordEncoder.sha512(input.getBytes());
    }

    private static byte[] sha512(byte[] input) {
        try {
            return MessageDigest.getInstance(ALGORITHM).digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Missing required message digest algorithm SHA-512");
        }
    }

    public String encode(String password) {
        String settingsHash = PasswordEncoder.randomSalt();
        return this.encode(password, settingsHash);
    }

    public String encode(String password, String preEncoded) {
        byte[] hash;
        preEncoded = preEncoded.substring(0, 12);
        int count_log2 = PasswordEncoder.passwordGetCountLog2(preEncoded);
        String salt = preEncoded.substring(4, 12);
        if (salt.length() != 8) {
            return null;
        }
        int count = 1 << count_log2;
        try {
            hash = PasswordEncoder.sha512(salt.concat(password));
            do {
                hash = PasswordEncoder.sha512(PasswordEncoder.joinBytes(hash, password.getBytes("UTF-8")));
            } while (--count > 0);
        }
        catch (Exception e) {
            LOG.error("Unable to encode the password", (Throwable)e);
            return null;
        }
        String output = preEncoded + PasswordEncoder.base64Encode(hash, hash.length);
        return output.length() > 0 ? output.substring(0, this.encodedHashLength) : null;
    }

    private static byte[] joinBytes(byte[] a, byte[] b) {
        byte[] combined = new byte[a.length + b.length];
        System.arraycopy(a, 0, combined, 0, a.length);
        System.arraycopy(b, 0, combined, a.length, b.length);
        return combined;
    }

    private static String base64Encode(byte[] input, int count) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        String itoa64 = PASSWORD_ITOA64;
        do {
            long value = PasswordEncoder.SignedByteToUnsignedLong(input[i++]);
            output.append(itoa64.charAt((int)value & 0x3F));
            if (i < count) {
                value |= PasswordEncoder.SignedByteToUnsignedLong(input[i]) << 8;
            }
            output.append(itoa64.charAt((int)(value >> 6) & 0x3F));
            if (i++ >= count) break;
            if (i < count) {
                value |= PasswordEncoder.SignedByteToUnsignedLong(input[i]) << 16;
            }
            output.append(itoa64.charAt((int)(value >> 12) & 0x3F));
            if (i++ >= count) break;
            output.append(itoa64.charAt((int)(value >> 18) & 0x3F));
        } while (i < count);
        return output.toString();
    }

    public static long SignedByteToUnsignedLong(byte b) {
        return b & 0xFF;
    }

    private static String randomSalt() {
        StringBuilder sb = new StringBuilder(11);
        sb.append("$S$D");
        for (int i = 0; i < 8; ++i) {
            sb.append(PASSWORD_ITOA64.charAt(RANDOM.nextInt(PASSWORD_ITOA64.length())));
        }
        return sb.toString();
    }
}

