/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.surety;

import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.EnumMap;
import java.util.Properties;
import org.gbif.identity.surety.IdentityEmailConfiguration;
import org.gbif.identity.surety.IdentityEmailManager;
import org.gbif.registry.surety.email.EmailTemplateProcessor;

public class InternalIdentitySuretyModule
extends PrivateModule {
    private final IdentityEmailConfiguration identityEmailConfiguration;

    public InternalIdentitySuretyModule(Properties filteredProperties) {
        this.identityEmailConfiguration = IdentityEmailConfiguration.from(filteredProperties);
    }

    @Override
    protected void configure() {
        this.expose(IdentityEmailManager.class);
    }

    @Provides
    @Singleton
    private IdentityEmailManager provideIdentityEmailManager() {
        EnumMap<IdentityEmailConfiguration.EmailType, EmailTemplateProcessor> templateProcessors = new EnumMap<IdentityEmailConfiguration.EmailType, EmailTemplateProcessor>(IdentityEmailConfiguration.EmailType.class);
        for (IdentityEmailConfiguration.EmailType emailType : IdentityEmailConfiguration.EmailType.values()) {
            templateProcessors.put(emailType, this.buildTemplateProcessor(emailType));
        }
        return new IdentityEmailManager(this.identityEmailConfiguration, templateProcessors);
    }

    private EmailTemplateProcessor buildTemplateProcessor(IdentityEmailConfiguration.EmailType emailType) {
        return new EmailTemplateProcessor(locale -> this.identityEmailConfiguration.getEmailSubject(emailType), locale -> emailType.getFtlTemplate());
    }
}

