/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.surety;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.gbif.api.model.common.GbifUser;
import org.gbif.identity.surety.IdentityEmailConfiguration;
import org.gbif.registry.surety.email.BaseEmailModel;
import org.gbif.registry.surety.email.BaseTemplateDataModel;
import org.gbif.registry.surety.email.EmailTemplateProcessor;
import org.gbif.registry.surety.model.ChallengeCode;

public class IdentityEmailManager {
    private final IdentityEmailConfiguration identityEmailConfiguration;
    private final Map<IdentityEmailConfiguration.EmailType, EmailTemplateProcessor> templateProcessors;

    IdentityEmailManager(IdentityEmailConfiguration identityEmailConfiguration, Map<IdentityEmailConfiguration.EmailType, EmailTemplateProcessor> templateProcessors) {
        this.identityEmailConfiguration = identityEmailConfiguration;
        this.templateProcessors = templateProcessors;
    }

    public BaseEmailModel generateNewUserEmailModel(GbifUser user, ChallengeCode challengeCode) throws IOException {
        try {
            return this.generateConfirmationEmailModel(user, this.identityEmailConfiguration.generateConfirmUserUrl(user.getUserName(), challengeCode.getCode()), IdentityEmailConfiguration.EmailType.NEW_USER);
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
    }

    public BaseEmailModel generateResetPasswordEmailModel(GbifUser user, ChallengeCode challengeCode) throws IOException {
        try {
            return this.generateConfirmationEmailModel(user, this.identityEmailConfiguration.generateResetPasswordUrl(user.getUserName(), challengeCode.getCode()), IdentityEmailConfiguration.EmailType.RESET_PASSWORD);
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
    }

    public BaseEmailModel generateWelcomeEmailModel(GbifUser user) throws IOException {
        try {
            return this.templateProcessors.get((Object)IdentityEmailConfiguration.EmailType.WELCOME).buildEmail(user.getEmail(), new Object(), Locale.ENGLISH);
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
    }

    private BaseEmailModel generateConfirmationEmailModel(GbifUser user, URL url, IdentityEmailConfiguration.EmailType emailType) throws IOException, TemplateException {
        BaseTemplateDataModel dataModel = new BaseTemplateDataModel(user.getUserName(), url);
        return this.templateProcessors.get((Object)emailType).buildEmail(user.getEmail(), dataModel, Locale.ENGLISH);
    }
}

