/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.surety;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;

class IdentityEmailConfiguration {
    static final String CONFIRM_USER_URL_TEMPLATE = "mail.urlTemplate.confirmUser";
    static final String RESET_PASSWORD_URL_TEMPLATE = "mail.urlTemplate.resetPassword";
    private static final ResourceBundle EMAIL_SUBJECT_RESOURCE = ResourceBundle.getBundle("email/subjects/identity_email_subjects", Locale.ENGLISH);
    private final String confirmUserUrlTemplate;
    private final String resetPasswordUrlTemplate;

    public static IdentityEmailConfiguration from(Properties filteredProperties) {
        return new IdentityEmailConfiguration(filteredProperties);
    }

    private IdentityEmailConfiguration(Properties filteredProperties) {
        this.confirmUserUrlTemplate = filteredProperties.getProperty(CONFIRM_USER_URL_TEMPLATE);
        this.resetPasswordUrlTemplate = filteredProperties.getProperty(RESET_PASSWORD_URL_TEMPLATE);
    }

    String getEmailSubject(EmailType identityEmailType) {
        return EMAIL_SUBJECT_RESOURCE.getString(identityEmailType.getSubjectKey());
    }

    URL generateConfirmUserUrl(String userName, UUID confirmationKey) throws MalformedURLException {
        return new URL(MessageFormat.format(this.confirmUserUrlTemplate, userName, confirmationKey.toString()));
    }

    URL generateResetPasswordUrl(String userName, UUID confirmationKey) throws MalformedURLException {
        return new URL(MessageFormat.format(this.resetPasswordUrlTemplate, userName, confirmationKey.toString()));
    }

    static enum EmailType {
        NEW_USER("createAccount", "create_confirmation_en.ftl"),
        RESET_PASSWORD("resetPassword", "reset_password_en.ftl"),
        WELCOME("welcome", "welcome_en.ftl");

        private final String subjectKey;
        private final String ftlTemplate;

        private EmailType(String subjectKey, String ftlTemplate) {
            this.subjectKey = subjectKey;
            this.ftlTemplate = ftlTemplate;
        }

        public String getSubjectKey() {
            return this.subjectKey;
        }

        public String getFtlTemplate() {
            return this.ftlTemplate;
        }
    }
}

