/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.service;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.gbif.api.model.common.GbifUser;
import org.gbif.identity.service.UserSuretyDelegate;
import org.gbif.identity.surety.IdentityEmailManager;
import org.gbif.registry.surety.SuretyConstants;
import org.gbif.registry.surety.email.BaseEmailModel;
import org.gbif.registry.surety.email.EmailSender;
import org.gbif.registry.surety.model.ChallengeCode;
import org.gbif.registry.surety.persistence.ChallengeCodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserSuretyDelegateImpl
implements UserSuretyDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(UserSuretyDelegateImpl.class);
    private final ChallengeCodeManager<Integer> challengeCodeManager;
    private final EmailSender emailSender;
    private final IdentityEmailManager identityEmailManager;

    @Inject
    UserSuretyDelegateImpl(EmailSender emailSender, ChallengeCodeManager<Integer> challengeCodeManager, IdentityEmailManager identityEmailManager) {
        this.emailSender = emailSender;
        this.challengeCodeManager = challengeCodeManager;
        this.identityEmailManager = identityEmailManager;
    }

    @Override
    public boolean hasChallengeCode(Integer userKey) {
        return this.challengeCodeManager.hasChallengeCode(userKey);
    }

    @Override
    public boolean isValidChallengeCode(Integer userKey, UUID challengeCode) {
        return this.challengeCodeManager.isValidChallengeCode(userKey, challengeCode);
    }

    @Override
    public void onNewUser(GbifUser user) {
        BaseEmailModel emailModel;
        ChallengeCode challengeCode = this.challengeCodeManager.create(user.getKey());
        try {
            emailModel = this.identityEmailManager.generateNewUserEmailModel(user, challengeCode);
        }
        catch (IOException e) {
            LOG.error(SuretyConstants.NOTIFY_ADMIN, "Error while trying to generate email to confirm user " + user.getUserName(), (Throwable)e);
            return;
        }
        this.emailSender.send(emailModel);
    }

    @Override
    public boolean confirmUser(GbifUser user, UUID confirmationObject) {
        Boolean confirmationSucceeded = Optional.ofNullable(user.getKey()).map(keyVal -> this.challengeCodeManager.isValidChallengeCode((Integer)keyVal, confirmationObject) && this.challengeCodeManager.remove((Integer)keyVal)).orElse(Boolean.FALSE);
        if (confirmationSucceeded.booleanValue()) {
            try {
                BaseEmailModel emailModel = this.identityEmailManager.generateWelcomeEmailModel(user);
                this.emailSender.send(emailModel);
            }
            catch (IOException e) {
                LOG.error(SuretyConstants.NOTIFY_ADMIN, "Error while trying to generate welcome email for user " + user.getUserName(), (Throwable)e);
            }
        }
        return confirmationSucceeded;
    }

    @Override
    public void onPasswordReset(GbifUser user) {
        BaseEmailModel emailModel;
        ChallengeCode challengeCode = this.challengeCodeManager.create(user.getKey());
        try {
            emailModel = this.identityEmailManager.generateResetPasswordEmailModel(user, challengeCode);
        }
        catch (IOException e) {
            LOG.error(SuretyConstants.NOTIFY_ADMIN, "Error while trying to generate email to reset password of user " + user.getUserName(), (Throwable)e);
            return;
        }
        this.emailSender.send(emailModel);
    }
}

