/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.service;

import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.service.common.IdentityAccessService;
import org.gbif.api.service.common.IdentityService;
import org.gbif.identity.mybatis.InternalIdentityMyBatisModule;
import org.gbif.identity.service.IdentityServiceImpl;
import org.gbif.identity.service.UserSuretyDelegate;
import org.gbif.identity.service.UserSuretyDelegateImpl;
import org.gbif.identity.surety.InternalIdentitySuretyModule;
import org.gbif.registry.surety.persistence.ChallengeCodeManager;
import org.gbif.registry.surety.persistence.ChallengeCodeMapper;
import org.gbif.registry.surety.persistence.ChallengeCodeSupportMapper;
import org.gbif.utils.file.properties.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalIdentityServiceModule
extends PrivateModule {
    private static final Logger LOG = LoggerFactory.getLogger(InternalIdentityServiceModule.class);
    public static final String CHALLENGE_CODE_SUPPORT_MAPPER_TYPE_NAME = "identityChallengeCodeSupportMapper";
    public static final TypeLiteral<ChallengeCodeSupportMapper<Integer>> CHALLENGE_CODE_SUPPORT_MAPPER_TYPE_LITERAL = new TypeLiteral<ChallengeCodeSupportMapper<Integer>>(){};
    public static final TypeLiteral<List<String>> APPKEYS_WHITELIST_TYPE_LITERAL = new TypeLiteral<List<String>>(){};
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final Properties rawProperties;
    private final Properties filteredProperties;
    private final List<String> appKeyWhitelist;

    public InternalIdentityServiceModule(Properties properties) {
        this.rawProperties = properties;
        this.filteredProperties = PropertiesUtil.filterProperties((Properties)properties, (String)"identity.surety.");
        String appkeysWl = properties.getProperty("identity.appkeys.whitelist");
        if (StringUtils.isNotBlank((CharSequence)appkeysWl)) {
            this.appKeyWhitelist = COMMA_PATTERN.splitAsStream(appkeysWl).map(String::trim).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            LOG.info("appKeyWhitelist {} ", this.appKeyWhitelist);
        } else {
            this.appKeyWhitelist = Collections.emptyList();
            LOG.warn("No appKeyWhitelist found. No appKey will be accepted.");
        }
    }

    @Override
    protected void configure() {
        this.install((Module)((Object)new InternalIdentityMyBatisModule(PropertiesUtil.filterProperties((Properties)this.rawProperties, (String)"registry.db."))));
        this.install(new InternalIdentitySuretyModule(this.filteredProperties));
        this.bind(UserSuretyDelegate.class).to(UserSuretyDelegateImpl.class).in(Scopes.SINGLETON);
        this.bind(IdentityService.class).to(IdentityServiceImpl.class).in(Scopes.SINGLETON);
        this.bind(IdentityAccessService.class).to(IdentityServiceImpl.class).in(Scopes.SINGLETON);
        this.expose(IdentityService.class);
        this.expose(IdentityAccessService.class);
        this.bind(APPKEYS_WHITELIST_TYPE_LITERAL).annotatedWith(Names.named("identity.appkeys.whitelist")).toInstance(this.appKeyWhitelist);
        this.expose(Key.get(APPKEYS_WHITELIST_TYPE_LITERAL, (Annotation)Names.named("identity.appkeys.whitelist")));
    }

    @Provides
    @Singleton
    private ChallengeCodeManager<Integer> provideChallengeCodeManager(ChallengeCodeMapper challengeCodeMapper, @Named(value="identityChallengeCodeSupportMapper") ChallengeCodeSupportMapper<Integer> challengeCodeSupportMapper) {
        return new ChallengeCodeManager<Integer>(challengeCodeMapper, challengeCodeSupportMapper);
    }
}

