/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.service;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.model.common.GbifUser;
import org.gbif.api.service.common.IdentityAccessService;
import org.gbif.api.service.common.IdentityService;
import org.gbif.identity.mybatis.InternalIdentityMyBatisModule;
import org.gbif.identity.service.IdentityServiceImpl;
import org.gbif.identity.service.UserSuretyDelegate;
import org.gbif.utils.file.properties.PropertiesUtil;

public class InternalIdentityAccessServiceModule
extends PrivateModule {
    private final Properties rawProperties;

    public InternalIdentityAccessServiceModule(Properties properties) {
        this.rawProperties = properties;
    }

    @Override
    protected void configure() {
        this.install((Module)((Object)new InternalIdentityMyBatisModule(PropertiesUtil.filterProperties((Properties)this.rawProperties, (String)"registry.db."))));
        this.bind(UserSuretyDelegate.class).to(EmptyUserSuretyDelegate.class);
        this.bind(IdentityService.class).to(IdentityServiceImpl.class);
        this.bind(IdentityAccessService.class).to(InnerIdentityService.class);
        this.expose(IdentityAccessService.class);
    }

    private static class InnerIdentityService
    implements IdentityAccessService {
        private final IdentityService identityService;

        @Inject
        InnerIdentityService(IdentityService identityService) {
            this.identityService = identityService;
        }

        @Nullable
        public GbifUser get(String s) {
            return this.identityService.get(s);
        }

        @Nullable
        public GbifUser authenticate(String username, String password) {
            return this.identityService.authenticate(username, password);
        }
    }

    private static class EmptyUserSuretyDelegate
    implements UserSuretyDelegate {
        private EmptyUserSuretyDelegate() {
        }

        @Override
        public boolean hasChallengeCode(Integer userKey) {
            return false;
        }

        @Override
        public boolean isValidChallengeCode(Integer userKey, UUID challengeCode) {
            return false;
        }

        @Override
        public void onNewUser(GbifUser user) {
        }

        @Override
        public boolean confirmUser(GbifUser user, UUID confirmationObject) {
            return false;
        }

        @Override
        public void onPasswordReset(GbifUser user) {
        }
    }
}

