/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.service;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.model.common.GbifUser;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingRequest;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;
import org.gbif.api.service.common.IdentityService;
import org.gbif.identity.model.ModelMutationError;
import org.gbif.identity.model.UserModelMutationResult;
import org.gbif.identity.mybatis.UserMapper;
import org.gbif.identity.service.UserSuretyDelegate;
import org.gbif.identity.util.PasswordEncoder;
import org.mybatis.guice.transactional.Transactional;

class IdentityServiceImpl
implements IdentityService {
    private final UserMapper userMapper;
    private final UserSuretyDelegate userSuretyDelegate;
    private static final Range<Integer> PASSWORD_LENGTH_RANGE = Range.between((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(256));
    private static final Validator BEAN_VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();
    private static final Function<String, String> NORMALIZE_USERNAME_FCT = StringUtils::trim;
    private static final Function<String, String> NORMALIZE_EMAIL_FCT = email -> Optional.ofNullable(email).map(String::trim).orElse(null);
    private static final PasswordEncoder PASSWORD_ENCODER = new PasswordEncoder();

    @Inject
    IdentityServiceImpl(UserMapper userMapper, UserSuretyDelegate userSuretyDelegate) {
        this.userMapper = userMapper;
        this.userSuretyDelegate = userSuretyDelegate;
    }

    @Override
    @Transactional
    public UserModelMutationResult create(GbifUser rawUser, String password) {
        GbifUser user = IdentityServiceImpl.normalize(rawUser);
        if (this.userMapper.get(user.getUserName()) != null || this.userMapper.getByEmail(user.getEmail()) != null) {
            return UserModelMutationResult.withError(ModelMutationError.USER_ALREADY_EXIST);
        }
        if (StringUtils.isBlank((CharSequence)password) || !PASSWORD_LENGTH_RANGE.contains((Object)password.length())) {
            return UserModelMutationResult.withError(ModelMutationError.PASSWORD_LENGTH_VIOLATION);
        }
        user.setPasswordHash(PASSWORD_ENCODER.encode(password));
        Optional<UserModelMutationResult> beanValidation = IdentityServiceImpl.validateBean(user, PrePersist.class);
        if (beanValidation.isPresent()) {
            return beanValidation.get();
        }
        this.userMapper.create(user);
        this.userSuretyDelegate.onNewUser(user);
        return UserModelMutationResult.onSuccess(user.getUserName(), user.getEmail());
    }

    @Override
    public UserModelMutationResult update(GbifUser rawUser) {
        GbifUser user = IdentityServiceImpl.normalize(rawUser);
        return Optional.ofNullable(this.getByKey(user.getKey())).map(currentUser -> {
            Optional<GbifUser> gbifUserAlreadyUsingEmail = Optional.of(currentUser).filter(u -> !u.getEmail().equalsIgnoreCase(user.getEmail())).map(u -> this.userMapper.getByEmail(user.getEmail()));
            if (gbifUserAlreadyUsingEmail.isPresent()) {
                return UserModelMutationResult.withError(ModelMutationError.EMAIL_ALREADY_IN_USE);
            }
            Optional<UserModelMutationResult> beanValidation = IdentityServiceImpl.validateBean(user, PostPersist.class);
            if (beanValidation.isPresent()) {
                return beanValidation.get();
            }
            this.userMapper.update(user);
            return UserModelMutationResult.onSuccess(user.getUserName(), user.getEmail());
        }).orElse(null);
    }

    private static Optional<UserModelMutationResult> validateBean(GbifUser gbifUser, Class<?> scope) {
        Set violations = BEAN_VALIDATOR.validate((Object)gbifUser, new Class[]{scope, Default.class});
        return violations.isEmpty() ? Optional.empty() : Optional.of(UserModelMutationResult.withError(violations));
    }

    @Override
    public void delete(int userKey) {
        this.userMapper.delete(userKey);
    }

    @Override
    public GbifUser getByKey(int key) {
        return this.userMapper.getByKey(key);
    }

    public GbifUser get(String identifier) {
        if (Strings.isNullOrEmpty(identifier)) {
            return null;
        }
        return StringUtils.contains((CharSequence)identifier, (CharSequence)"@") ? this.getByEmail(identifier) : this.userMapper.get(NORMALIZE_USERNAME_FCT.apply(identifier));
    }

    private GbifUser getByEmail(String email) {
        return this.userMapper.getByEmail(NORMALIZE_EMAIL_FCT.apply(email));
    }

    @Override
    public PagingResponse<GbifUser> list(@Nullable Pageable pageable) {
        return this.search(null, pageable);
    }

    @Override
    public PagingResponse<GbifUser> search(@Nullable String query, @Nullable Pageable pageable) {
        return IdentityServiceImpl.pagingResponse(pageable, this.userMapper.count(query), this.userMapper.search(query, pageable));
    }

    public GbifUser authenticate(String username, String password) {
        if (Strings.isNullOrEmpty(username) || password == null) {
            return null;
        }
        return Optional.ofNullable(this.get(username)).filter(user -> PASSWORD_ENCODER.encode(password, user.getPasswordHash()).equalsIgnoreCase(user.getPasswordHash()) && (!this.userSuretyDelegate.hasChallengeCode(user.getKey()) || user.getLastLogin() != null)).orElse(null);
    }

    @Override
    public void updateLastLogin(int userKey) {
        this.userMapper.updateLastLogin(userKey);
    }

    @Override
    public boolean hasPendingConfirmation(int userKey) {
        return this.userSuretyDelegate.hasChallengeCode(userKey);
    }

    @Override
    public boolean isConfirmationKeyValid(int userKey, UUID confirmationKey) {
        return this.userSuretyDelegate.isValidChallengeCode(userKey, confirmationKey);
    }

    @Override
    public boolean confirmUser(int userKey, UUID confirmationKey) {
        return Optional.ofNullable(confirmationKey).map(confirmationKeyVal -> this.userSuretyDelegate.confirmUser(this.getByKey(userKey), (UUID)confirmationKeyVal)).orElse(Boolean.FALSE);
    }

    @Override
    public void resetPassword(int userKey) {
        Optional.ofNullable(this.userMapper.getByKey(userKey)).ifPresent(this.userSuretyDelegate::onPasswordReset);
    }

    @Override
    public UserModelMutationResult updatePassword(int userKey, String newPassword, UUID challengeCode) {
        return this.confirmUser(userKey, challengeCode) ? this.updatePassword(userKey, newPassword) : UserModelMutationResult.withSingleConstraintViolation("challengeCode", " Incorrect");
    }

    @Override
    public UserModelMutationResult updatePassword(int userKey, String newPassword) {
        return Optional.ofNullable(this.userMapper.getByKey(userKey)).map(user -> {
            if (StringUtils.isBlank((CharSequence)newPassword) || !PASSWORD_LENGTH_RANGE.contains((Object)newPassword.length())) {
                return UserModelMutationResult.withError(ModelMutationError.PASSWORD_LENGTH_VIOLATION);
            }
            user.setPasswordHash(PASSWORD_ENCODER.encode(newPassword));
            this.userMapper.update((GbifUser)user);
            return UserModelMutationResult.onSuccess();
        }).orElse(UserModelMutationResult.withSingleConstraintViolation("user", " Unknown"));
    }

    private static GbifUser normalize(GbifUser gbifUser) {
        gbifUser.setUserName(NORMALIZE_USERNAME_FCT.apply(gbifUser.getUserName()));
        gbifUser.setEmail(NORMALIZE_EMAIL_FCT.apply(gbifUser.getEmail()));
        return gbifUser;
    }

    private static PagingResponse<GbifUser> pagingResponse(@Nullable Pageable page, long count, List<GbifUser> result) {
        return new PagingResponse((Pageable)(page == null ? new PagingRequest() : page), Long.valueOf(count), result);
    }
}

