/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.identity.model;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.gbif.api.model.common.AbstractGbifUser;
import org.gbif.identity.model.ModelMutationError;

public class UserModelMutationResult {
    private String username;
    private String email;
    private ModelMutationError modelError;
    private Map<String, String> constraintViolation;

    public static UserModelMutationResult onSuccess() {
        return new UserModelMutationResult(null, null);
    }

    public static UserModelMutationResult onSuccess(String username, String email) {
        return new UserModelMutationResult(username, email);
    }

    public static UserModelMutationResult withError(ModelMutationError modelError) {
        return new UserModelMutationResult(modelError);
    }

    public static UserModelMutationResult withSingleConstraintViolation(String key, String value) {
        UserModelMutationResult userModelMutationResult = new UserModelMutationResult(ModelMutationError.CONSTRAINT_VIOLATION);
        HashMap<String, String> constraintViolation = new HashMap<String, String>();
        constraintViolation.put(key, value);
        userModelMutationResult.setConstraintViolation(constraintViolation);
        return userModelMutationResult;
    }

    public static <T extends AbstractGbifUser> UserModelMutationResult withError(Set<ConstraintViolation<T>> constraintViolation) {
        HashMap<String, String> cvMap = new HashMap<String, String>();
        constraintViolation.forEach(cv -> cvMap.put(cv.getPropertyPath().toString(), cv.getMessage()));
        return new UserModelMutationResult(cvMap);
    }

    private UserModelMutationResult(String username, String email) {
        this.username = username;
        this.email = email;
    }

    private UserModelMutationResult(ModelMutationError modelError) {
        this.modelError = modelError;
    }

    public UserModelMutationResult() {
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setError(ModelMutationError modelError) {
        this.modelError = modelError;
    }

    public void setConstraintViolation(Map<String, String> constraintViolation) {
        this.constraintViolation = constraintViolation;
    }

    public UserModelMutationResult(Map<String, String> constraintViolation) {
        this.modelError = ModelMutationError.CONSTRAINT_VIOLATION;
        this.constraintViolation = constraintViolation;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public Map<String, String> getConstraintViolation() {
        return this.constraintViolation;
    }

    public ModelMutationError getError() {
        return this.modelError;
    }

    public boolean containsError() {
        return this.modelError != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("username", this.username).add("email", this.email).add("modelError", (Object)this.modelError).add("constraintViolation", this.constraintViolation).toString();
    }
}

