/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.service.common;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gbif.api.model.common.GbifUser;

public class LoggedUser {
    private String userName;
    private String firstName;
    private String lastName;
    private String email;
    private final Map<String, String> settings = Maps.newHashMap();

    public static LoggedUser from(GbifUser user) {
        if (user == null) {
            return null;
        }
        return new LoggedUser(user);
    }

    public LoggedUser() {
    }

    private LoggedUser(GbifUser user) {
        this.userName = user.getUserName();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.email = user.getEmail();
        this.settings.putAll(user.getSettings());
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }
}

