/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.vocab;

import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public enum ALATerm implements Term
{
    verbatimNomenclaturalCode,
    verbatimTaxonomicStatus,
    verbatimNomenclaturalStatus,
    nameComplete,
    nameFormatted,
    nameID,
    status,
    priority,
    kingdomID,
    phylumID,
    classID,
    orderID,
    familyID,
    genusID,
    speciesID,
    subphylum,
    subclass,
    suborder,
    infraorder,
    TaxonVariant,
    TaxonomicIssue;

    public static final String NS = "http://ala.org.au/terms/1.0/";
    public static final String PREFIX = "ala:";

    public String qualifiedName() {
        return NS + this.simpleName();
    }

    public String simpleName() {
        return this.name();
    }

    public String toString() {
        return PREFIX + this.name();
    }

    static {
        TermFactory factory = TermFactory.instance();
        for (ALATerm term : ALATerm.values()) {
            factory.addTerm(term.simpleName(), (Term)term, true);
            factory.addTerm(term.qualifiedName(), (Term)term);
            factory.addTerm(PREFIX + term.simpleName(), (Term)term);
        }
    }
}

