/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TaxonResolution {
    private static Comparator<TaxonConceptInstance> RANK_ORDER = new Comparator<TaxonConceptInstance>(){

        @Override
        public int compare(TaxonConceptInstance o1, TaxonConceptInstance o2) {
            if (o1.isPrimary() && !o2.isPrimary()) {
                return 1;
            }
            if (!o1.isPrimary() && o2.isPrimary()) {
                return -1;
            }
            if (o1.isAccepted() && !o2.isAccepted()) {
                return 1;
            }
            if (!o1.isAccepted() && o2.isAccepted()) {
                return -1;
            }
            return o1.getRank().getSortOrder() - o2.getRank().getSortOrder();
        }
    };
    private Map<TaxonConceptInstance, TaxonConceptInstance> resolution;
    private List<TaxonConceptInstance> principal;
    private List<TaxonConceptInstance> used;
    private Set<TaxonConceptInstance> unresolved;

    public TaxonResolution(List<TaxonConceptInstance> principal) {
        this.principal = principal;
        this.resolution = new HashMap<TaxonConceptInstance, TaxonConceptInstance>();
        this.used = new ArrayList<TaxonConceptInstance>(principal);
        this.unresolved = new HashSet<TaxonConceptInstance>();
    }

    public TaxonResolution() {
        this(new ArrayList<TaxonConceptInstance>());
    }

    public Map<TaxonConceptInstance, TaxonConceptInstance> getResolution() {
        return this.resolution;
    }

    public List<TaxonConceptInstance> getPrincipal() {
        return this.principal;
    }

    public List<TaxonConceptInstance> getUsed() {
        return this.used;
    }

    public Set<TaxonConceptInstance> getUnresolved() {
        return this.unresolved;
    }

    public void addInternal(TaxonConceptInstance instance, TaxonConceptInstance resolved, Taxonomy taxonomy) {
        if (!this.used.contains(resolved)) {
            taxonomy.report(IssueType.NOTE, "taxonResolution.added", resolved);
            this.used.add(resolved);
        }
        this.resolution.put(instance, resolved);
    }

    public void addExternal(TaxonConceptInstance instance, TaxonConceptInstance resolved, Taxonomy taxonomy) {
        this.resolution.put(instance, resolved);
    }

    public RankType getRank() {
        return this.principal.stream().max(RANK_ORDER).map(TaxonConceptInstance::getRank).orElse(null);
    }

    public boolean hasAccepted() {
        return this.principal.stream().anyMatch(TaxonConceptInstance::isAccepted);
    }

    public TaxonConceptInstance getResolved(TaxonConceptInstance instance) {
        return this.resolution.get(instance);
    }

    public List<TaxonConceptInstance> getChildren(TaxonConceptInstance instance) {
        return this.resolution.keySet().stream().filter(tci -> this.resolution.get(tci) == instance).collect(Collectors.toList());
    }

    public boolean validate(Collection<TaxonConceptInstance> instances, Reporter reporter) {
        boolean valid = true;
        for (TaxonConceptInstance tci : this.getUsed()) {
            valid = this.validate(tci, reporter) && valid;
        }
        for (TaxonConceptInstance tci : this.getPrincipal()) {
            valid = this.validate(tci, reporter) && valid;
        }
        for (TaxonConceptInstance tci : instances) {
            valid = this.validate(tci, reporter) && valid;
        }
        return valid;
    }

    protected boolean validate(TaxonConceptInstance instance, Reporter reporter) {
        boolean valid;
        boolean bl = valid = this.getResolved(instance) != null;
        if (!valid) {
            reporter.report(IssueType.ERROR, "taxonResolver.validation.noResolution", instance);
        }
        return valid;
    }
}

