/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.ScientificName;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonResolution;
import au.org.ala.names.index.TaxonResolver;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import au.org.ala.names.util.DwcaWriter;
import au.org.ala.vocab.ALATerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;

public class TaxonConcept
extends TaxonomicElement<TaxonConcept, ScientificName> {
    private NameKey key;
    private List<TaxonConceptInstance> instances;
    private TaxonResolution resolution;

    public TaxonConcept(ScientificName name, NameKey key) {
        super(name);
        this.key = key;
        this.instances = new ArrayList<TaxonConceptInstance>();
        this.resolution = null;
    }

    public NameKey getKey() {
        return this.key;
    }

    public boolean isResolved() {
        return this.resolution != null;
    }

    public TaxonConceptInstance getResolved(TaxonConceptInstance instance) {
        if (this.resolution == null) {
            return instance;
        }
        TaxonConceptInstance resolved = this.resolution.getResolved(instance);
        if (resolved == null) {
            throw new IllegalStateException("Unable to get resolution for " + this);
        }
        return resolved;
    }

    @Override
    public TaxonConceptInstance addInstance(NameKey instanceKey, TaxonConceptInstance instance) {
        instance.setContainer(this);
        this.instances.add(instance);
        return instance;
    }

    public TaxonConceptInstance findInstance(NameProvider provider, boolean acceptedOnly) {
        for (TaxonConceptInstance instance : this.instances) {
            if (!instance.getProvider().equals(provider) || acceptedOnly && !instance.isAccepted()) continue;
            return instance;
        }
        return null;
    }

    public void resolveTaxon(Taxonomy taxonomy) throws IndexBuilderException {
        if (this.resolution != null) {
            return;
        }
        TaxonResolver resolver = taxonomy.getResolver();
        List<TaxonConceptInstance> principals = resolver.principals(this, this.instances);
        this.resolution = resolver.resolve(this, principals, this.instances);
        taxonomy.count("count.resolve.taxonConcept");
    }

    @Override
    public void reallocate(TaxonConcept element, Taxonomy taxonomy) {
        taxonomy.report(IssueType.NOTE, "taxonConcept.reallocated", element, this);
        taxonomy.count("count.reallocate.taxonConcept");
        TaxonConceptInstance representative = this.getRepresentative();
        if (representative == null || this.resolution == null) {
            throw new IndexBuilderException("Unable to reallocate " + element + " to " + this + " without representative and resolution");
        }
        element.resolution = new TaxonResolution();
        for (TaxonConceptInstance tci : element.instances) {
            tci.setContainer(this);
            this.instances.add(tci);
            this.resolution.addExternal(tci, representative, taxonomy);
            element.resolution.addExternal(tci, representative, taxonomy);
        }
        element.instances.clear();
    }

    public void write(Taxonomy taxonomy, DwcaWriter writer) throws IOException {
        for (TaxonConceptInstance tci : this.resolution.getUsed()) {
            if (tci.isForbidden()) continue;
            List<TaxonConceptInstance> allocated = this.resolution.getChildren(tci);
            if (allocated == null || allocated.isEmpty()) {
                taxonomy.report(IssueType.NOTE, "taxonConcept.noInstances", tci);
                continue;
            }
            writer.newRecord(tci.getTaxonID());
            Map<Term, String> values = tci.getTaxonMap(taxonomy);
            for (Term term : taxonomy.outputTerms((Term)DwcTerm.Taxon)) {
                if (term == DwcTerm.taxonID) continue;
                writer.addCoreColumn(term, values.get(term));
            }
            for (TaxonConceptInstance sub : allocated) {
                if (sub.isForbidden()) continue;
                this.writeExtension(ALATerm.TaxonVariant, sub == tci ? values : sub.getTaxonMap(taxonomy), taxonomy, writer);
                for (Map<Term, String> id : sub.getIdentifierMaps(taxonomy)) {
                    this.writeExtension((Term)GbifTerm.Identifier, id, taxonomy, writer);
                }
                for (Map<Term, String> vn : sub.getVernacularMaps(taxonomy)) {
                    this.writeExtension((Term)GbifTerm.VernacularName, vn, taxonomy, writer);
                }
                for (Map<Term, String> dist : sub.getDistributionMaps(taxonomy)) {
                    this.writeExtension((Term)GbifTerm.Distribution, dist, taxonomy, writer);
                }
            }
        }
        taxonomy.count("count.write.taxonConcept");
    }

    private void writeExtension(Term type, Map<Term, String> values, Taxonomy taxonomy, DwcaWriter writer) throws IOException {
        LinkedHashMap<Term, String> ext = new LinkedHashMap<Term, String>();
        List<Term> terms = taxonomy.outputTerms(type);
        for (Term term : terms) {
            String value = values.get(term);
            ext.put(term, value);
        }
        if (!ext.isEmpty()) {
            writer.addExtensionRecord(type, ext);
        }
    }

    @Override
    public RankType getRank() {
        return this.resolution == null ? this.key.getRank() : this.resolution.getRank();
    }

    public boolean hasAccepted() {
        return this.resolution != null ? this.resolution.hasAccepted() : this.instances.stream().anyMatch(tci -> tci.isAccepted() && !tci.isForbidden());
    }

    public boolean isFormal() {
        return this.key.isFormal();
    }

    public boolean isAuthored() {
        return this.key.getScientificNameAuthorship() != null;
    }

    public void addInferredSynonym(TaxonConcept principal, Taxonomy taxonomy) {
        TaxonResolver resolver = taxonomy.getResolver();
        TaxonConceptInstance representative = principal.getRepresentative();
        if (representative == null) {
            taxonomy.report(IssueType.ERROR, "taxonConcept.representative", principal, this);
            return;
        }
        List inferred = this.resolution.getUsed().stream().filter(tci -> tci.isAccepted()).map(tci -> representative.createInferredSynonym(this, tci.getScientificName(), tci.getScientificNameAuthorship(), tci.getYear(), taxonomy)).collect(Collectors.toList());
        if (inferred.isEmpty()) {
            taxonomy.report(IssueType.ERROR, "taxonConcept.inferredSynonyms", principal, this);
            return;
        }
        this.instances.addAll(inferred);
        List<TaxonConceptInstance> used = this.instances.stream().filter(tci -> tci.isInferredSynonym()).collect(Collectors.toList());
        if (used.size() > 1) {
            taxonomy.report(IssueType.NOTE, "taxonConcept.multipleInferredSynonyms", this, used.get(0), used.get(1));
        }
        this.resolution = resolver.resolve(this, used, this.instances);
        taxonomy.count("count.resolve.inferredSynonym");
    }

    @Override
    public TaxonConceptInstance getRepresentative() {
        return this.resolution == null ? this.instances.get(0) : this.resolution.getUsed().get(0);
    }

    public String toString() {
        return "TC[" + this.key.getScientificName() + ", " + this.key.getScientificNameAuthorship() + "]";
    }

    public boolean isOwned() {
        TaxonConceptInstance accepted = this.getRepresentative();
        return accepted.getContainer() == this && accepted.isOwned();
    }

    @Override
    public String getId() {
        TaxonConceptInstance rep;
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.key.getScientificName());
        if (this.key.getScientificNameAuthorship() != null) {
            sb.append(" ");
            sb.append(this.key.getScientificNameAuthorship());
        }
        if ((rep = this.getRepresentative()) != null) {
            sb.append(" [");
            sb.append(rep.getTaxonID());
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String getScientificName() {
        return this.key.getScientificName();
    }

    @Override
    public String getScientificNameAuthorship() {
        return this.key.getScientificNameAuthorship();
    }

    @Override
    public int getPrincipalScore() {
        TaxonConceptInstance representative = this.getRepresentative();
        return representative != null ? representative.getPrincipalScore() : -1000000;
    }

    @Override
    public int getProviderScore() {
        TaxonConceptInstance representative = this.getRepresentative();
        return representative != null ? representative.getProviderScore() : -1000000;
    }

    @Override
    public boolean validate(Taxonomy taxonomy) {
        boolean valid = true;
        if (this.instances.isEmpty()) {
            taxonomy.report(IssueType.VALIDATION, "taxonConcept.validation.noInstances", this);
            valid = false;
        }
        for (TaxonConceptInstance tci : this.instances) {
            if (tci.getContainer() != this) {
                taxonomy.report(IssueType.VALIDATION, "taxonConcept.validation.instanceParent", tci, this);
                valid = false;
            }
            if (taxonomy.getInstance(tci.getTaxonID()) == tci) continue;
            taxonomy.report(IssueType.VALIDATION, "taxonConcept.validation.instanceTaxonomy", tci, this);
            valid = false;
        }
        if (this.isResolved() && !this.resolution.validate(this.instances, (Reporter)taxonomy)) {
            valid = false;
        }
        return valid;
    }
}

